/*
 * Decompiled with CFR 0.152.
 */
package stream.generator;

import cern.jet.random.Normal;
import cern.jet.random.engine.MersenneTwister64;
import cern.jet.random.engine.RandomEngine;
import stream.generator.DistributionFunction;

public class ColtGaussian
implements DistributionFunction {
    protected Long seed;
    protected Double mean = 0.0;
    protected Double variance = 1.0;
    protected Normal rnd;
    protected MersenneTwister64 rndEngine;

    public ColtGaussian(Double mean, Double variance, Long seed) {
        this.rndEngine = new MersenneTwister64(seed.intValue());
        this.rnd = new Normal(mean.doubleValue(), variance.doubleValue(), (RandomEngine)this.rndEngine);
        this.mean = mean;
        this.variance = variance;
    }

    public ColtGaussian(Double mean, Double variance) {
        this(mean, variance, null);
    }

    public Long getSeed() {
        return this.seed;
    }

    public void setSeed(Long seed) {
        this.seed = seed;
        this.rndEngine = new MersenneTwister64(seed.intValue());
    }

    public Double getMean() {
        return this.mean;
    }

    public void setMean(Double mean) {
        this.mean = mean;
        this.rnd.setState(mean.doubleValue(), this.variance.doubleValue());
    }

    public Double getVariance() {
        return this.variance;
    }

    public void setVariance(Double variance) {
        this.variance = variance;
        this.rnd.setState(this.mean.doubleValue(), variance.doubleValue());
    }

    public Double next() {
        return this.rnd.nextDouble();
    }

    public String toHtml() {
        return "<p>Gaussian, mean: <i>" + this.mean + "</i>, variance: <i>" + this.variance + "</i>, random seed: <code>" + this.seed + "</code></p>";
    }

    public String toString() {
        return "N(" + this.mean + ", " + this.variance + ")";
    }

    @Override
    public Double p(Double x) {
        return this.rnd.pdf(x.doubleValue());
    }
}

