/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.Data;
import stream.Processor;
import stream.annotations.Description;

@Description(group="Data Stream.Processing.Transformations.Data")
public class NumericalBinning
implements Processor {
    static Logger log = LoggerFactory.getLogger(NumericalBinning.class);
    Double minimum = 0.0;
    Double maximum = 10.0;
    Integer bins = 10;
    String[] keys = null;
    Bucket[] buckets = null;

    public Double getMinimum() {
        return this.minimum;
    }

    public void setMinimum(Double minimum) {
        this.minimum = minimum;
    }

    public Double getMaximum() {
        return this.maximum;
    }

    public void setMaximum(Double maximum) {
        this.maximum = maximum;
    }

    public Integer getBins() {
        return this.bins;
    }

    public void setBins(Integer bins) {
        this.bins = bins;
        this.buckets = null;
    }

    public String[] getKeys() {
        return this.keys;
    }

    public void setKeys(String[] keys) {
        this.keys = keys;
    }

    public void setKey(String key) {
        if (key != null) {
            this.keys = new String[]{key};
        }
    }

    public String getKey() {
        return this.keys[0];
    }

    public void init() throws Exception {
        this.buckets = new Bucket[Math.max(1, this.bins)];
        double step = (this.maximum - this.minimum) / this.bins.doubleValue();
        double last = this.minimum;
        for (int i = 0; i < this.buckets.length - 1; ++i) {
            this.buckets[i] = new Bucket(last, last + step);
            last += step;
        }
        this.buckets[this.buckets.length - 1] = new Bucket(last, this.maximum);
    }

    public Data process(Data data) {
        if (this.buckets == null) {
            try {
                this.init();
            }
            catch (Exception e) {
                throw new RuntimeException("Initialization failed: " + e.getMessage());
            }
        }
        if (this.keys == null || this.keys.length < 1) {
            return data;
        }
        for (String key : this.keys) {
            Serializable value = (Serializable)data.get((Object)key);
            if (value instanceof Number) {
                Number num = (Number)value;
                data.put((Object)key, (Object)this.map(num.doubleValue()));
                continue;
            }
            try {
                Double val = new Double(value.toString());
                data.put((Object)key, (Object)this.map(val));
            }
            catch (Exception e) {
                log.debug("Failed to parse double value from '{}' for attribute '{}'!", (Object)value, (Object)key);
            }
        }
        return data;
    }

    protected Bucket map(Double d) {
        if (d < this.buckets[0].upper) {
            return this.buckets[0];
        }
        for (int i = 0; i < this.buckets.length; ++i) {
            if (i + 1 >= this.buckets.length || !(this.buckets[i + 1].lower > d)) continue;
            return this.buckets[i];
        }
        return this.buckets[this.buckets.length - 1];
    }

    public class Bucket
    implements Serializable,
    Comparable<Bucket> {
        private static final long serialVersionUID = 1874196246174345683L;
        final Double lower;
        final Double upper;
        final String asString;

        public Bucket(double low, double high) {
            this.lower = low;
            this.upper = high;
            DecimalFormatSymbols otherSymbols = new DecimalFormatSymbols(Locale.getDefault());
            otherSymbols.setDecimalSeparator('.');
            DecimalFormat fmt = new DecimalFormat("0.0#####", otherSymbols);
            this.asString = "Range[" + fmt.format(this.lower) + ";" + fmt.format(this.upper) + ")";
        }

        public String toString() {
            return this.asString;
        }

        @Override
        public int compareTo(Bucket arg0) {
            if (arg0 == null) {
                return 1;
            }
            if (arg0 == this) {
                return 0;
            }
            int r = this.lower.compareTo(arg0.lower);
            if (r == 0) {
                r = this.upper.compareTo(arg0.upper);
            }
            return r;
        }
    }
}

