/*
 * Decompiled with CFR 0.152.
 */
package stream.data;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.security.Key;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import net.minidev.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import stream.AbstractProcessor;
import stream.Data;
import stream.ProcessContext;
import stream.data.DataFactory;
import stream.io.Serializer;
import stream.util.JavaSerializer;
import stream.util.MD5;

public class Encrypt
extends AbstractProcessor {
    static Logger log = LoggerFactory.getLogger(Encrypt.class);
    public static final String ID_KEY = "encrypted:id";
    public static final String CIPHER_KEY = "encrypted:cipher";
    public static final String DATA_KEY = "encrypted:data";
    public static final String SERIALIZER_KEY = "serializer:class";
    String serialize = "java";
    Serializer serializer = new JavaSerializer();
    String secret;
    String cipher = "AES/CBC/PKCS5Padding";
    SecretKeySpec key;
    Cipher c;

    public void init(ProcessContext ctx) throws Exception {
        super.init(ctx);
        this.key = new SecretKeySpec(MD5.md5((String)this.secret).getBytes(), "AES");
        this.c = Cipher.getInstance(this.cipher);
        if (this.secret == null) {
            throw new Exception("No 'secret' parameter specified!");
        }
        if (this.secret.trim().isEmpty()) {
            throw new Exception("Parameter 'secret' does not contain any information!");
        }
        try {
            log.debug("Initializing cipher for '{}'", (Object)this.cipher);
            Cipher c = Cipher.getInstance(this.cipher);
            log.debug("Cipher initialized: {}", (Object)c);
        }
        catch (Exception e) {
            log.error("Failed to initialized cipher '" + this.cipher + "': " + e.getMessage());
            throw new Exception("Failed to initialized cipher '" + this.cipher + "': " + e.getMessage());
        }
    }

    public Data process(Data input) {
        UUID uuid = UUID.randomUUID();
        String id = uuid.toString();
        Data enc = DataFactory.create();
        byte[] ivData = Encrypt.computeIV(id, this.secret);
        enc.put((Object)ID_KEY, (Object)id);
        try {
            byte[] data;
            if ("json".equalsIgnoreCase(this.serialize)) {
                String json = JSONObject.toJSONString((Map)input);
                data = json.getBytes();
                enc.put((Object)SERIALIZER_KEY, (Object)"json");
            } else {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                this.serializer.write((Serializable)input, (OutputStream)baos);
                baos.flush();
                baos.close();
                data = baos.toByteArray();
                enc.put((Object)SERIALIZER_KEY, (Object)this.serializer.getClass().getCanonicalName());
            }
            IvParameterSpec iv = new IvParameterSpec(ivData);
            this.c.init(1, (Key)this.key, iv);
            data = this.c.doFinal(data);
            enc.put((Object)CIPHER_KEY, (Object)this.cipher);
            enc.put((Object)DATA_KEY, (Object)data);
            log.debug("Encrypted serialized item into {} bytes", (Object)data.length);
        }
        catch (Exception e) {
            log.error("Encryption failed: {}", (Object)e.getMessage());
            return null;
        }
        return enc;
    }

    public String getSecret() {
        return this.secret;
    }

    public void setSecret(String secret) {
        this.secret = secret;
    }

    public String getSerializer() {
        return this.serialize;
    }

    public void setSerializer(String serialize) {
        this.serialize = serialize;
    }

    public static byte[] computeIV(String id, String secret) {
        String from = MD5.md5((String)(id + secret));
        byte[] ivData = new byte[16];
        for (int i = 0; i < ivData.length; ++i) {
            ivData[i] = i < from.length() ? (byte)from.charAt(i) : (byte)0;
        }
        return ivData;
    }
}

