/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.awt;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import javax.swing.JOptionPane;

public class Windows {
    private static final String PROPERTY_FOCUSED_WINDOW = "focusedWindow";
    private static Reference lastFocusManager = new WeakReference<Object>(null);
    private static Reference lastFocusedWindow;
    private static Reference parent;
    private static PropertyChangeListener focusListener;

    Windows() {
    }

    public static synchronized Window getParentWindow() {
        Window w = Windows.findFirstShowingWindow((Window)parent.get());
        if (w == null && (w = Windows.findFirstShowingWindow(Windows.getLastFocusedWindow())) == null) {
            w = Windows.getAnyShowingWindow();
        }
        if (w != parent.get()) {
            parent = new WeakReference<Window>(w);
        }
        return w != null ? w : JOptionPane.getRootFrame();
    }

    private static Window findFirstShowingWindow(Window w) {
        for (Container c = w; c != null; c = c.getParent()) {
            if (!(c instanceof Window) || !((Component)c).isShowing()) continue;
            return c;
        }
        return null;
    }

    public static synchronized void setParentWindow(Window w) {
        parent = new WeakReference<Window>(w);
    }

    public static synchronized Window getLastFocusedWindow() {
        Windows.observeFocusedWindow();
        return (Window)lastFocusedWindow.get();
    }

    private static void observeFocusedWindow() {
        KeyboardFocusManager lfm = (KeyboardFocusManager)lastFocusManager.get();
        KeyboardFocusManager fm = KeyboardFocusManager.getCurrentKeyboardFocusManager();
        if (fm == lfm) {
            return;
        }
        if (lfm != null) {
            lfm.removePropertyChangeListener(PROPERTY_FOCUSED_WINDOW, focusListener);
        }
        fm.addPropertyChangeListener(PROPERTY_FOCUSED_WINDOW, focusListener);
        lastFocusManager = new WeakReference<KeyboardFocusManager>(fm);
        Windows.setLastFocusedWindow0(fm.getFocusedWindow());
    }

    private static synchronized void setLastFocusedWindow(Window w) {
        Windows.setLastFocusedWindow0(w);
    }

    private static void setLastFocusedWindow0(Window w) {
        if (!(w != null && w.isShowing() || (w = (Window)lastFocusedWindow.get()) == null || w.isShowing())) {
            w = null;
        }
        lastFocusedWindow = new WeakReference<Window>(w);
    }

    private static Window getAnyShowingWindow() {
        return Windows.getAnyShowingWindow(Frame.getFrames());
    }

    private static Window getAnyShowingWindow(Window[] windows) {
        int l = windows.length;
        for (int i = 0; i < l; ++i) {
            Window window = windows[i];
            if (window.isShowing()) {
                return window;
            }
            if ((window = Windows.getAnyShowingWindow(window.getOwnedWindows())) == null) continue;
            return window;
        }
        return null;
    }

    static {
        parent = lastFocusedWindow = lastFocusManager;
        focusListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                Windows.setLastFocusedWindow((Window)evt.getNewValue());
            }
        };
    }
}

