/*
 * Decompiled with CFR 0.152.
 */
package org.nustaq.serialization;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.NotActiveException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import org.nustaq.serialization.FSTClazzInfo;
import org.nustaq.serialization.FSTClazzInfoRegistry;
import org.nustaq.serialization.FSTConfiguration;
import org.nustaq.serialization.FSTDecoder;
import org.nustaq.serialization.FSTObjectRegistry;
import org.nustaq.serialization.FSTObjectSerializer;
import org.nustaq.serialization.VersionConflictListener;
import org.nustaq.serialization.util.FSTUtil;

public class FSTObjectInput
implements ObjectInput {
    static ByteArrayInputStream empty = new ByteArrayInputStream(new byte[0]);
    protected FSTDecoder codec;
    FSTObjectRegistry objects;
    Stack<String> debugStack;
    int curDepth;
    ArrayList<CallbackEntry> callbacks;
    FSTConfiguration conf;
    boolean ignoreAnnotations;
    FSTClazzInfoRegistry clInfoRegistry;
    ConditionalCallback conditionalCallback;
    int readExternalReadAHead = 8000;
    VersionConflictListener versionConflictListener;
    FSTClazzInfo.FSTFieldInfo infoCache;
    boolean closed = false;
    MyObjectStream fakeWrapper;

    public FSTConfiguration getConf() {
        return this.conf;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.codec.readPlainBytes(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.codec.skip(n);
        return n;
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.codec.readFByte() != 0;
    }

    @Override
    public byte readByte() throws IOException {
        return this.codec.readFByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.codec.readFByte() + 256 & 0xFF;
    }

    @Override
    public short readShort() throws IOException {
        return this.codec.readFShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.readShort() + 65536 & 0xFFFF;
    }

    @Override
    public char readChar() throws IOException {
        return this.codec.readFChar();
    }

    @Override
    public int readInt() throws IOException {
        return this.codec.readFInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.codec.readFLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.codec.readFFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.codec.readFDouble();
    }

    @Override
    public String readLine() throws IOException {
        throw new RuntimeException("not implemented");
    }

    @Override
    public String readUTF() throws IOException {
        return this.codec.readStringUTF();
    }

    public FSTObjectInput() throws IOException {
        this(empty, FSTConfiguration.getDefaultConfiguration());
    }

    public FSTObjectInput(FSTConfiguration conf) {
        this(empty, conf);
    }

    public FSTObjectInput(InputStream in) throws IOException {
        this(in, FSTConfiguration.getDefaultConfiguration());
    }

    public FSTObjectInput(InputStream in, FSTConfiguration conf) {
        this.codec = conf.createStreamDecoder();
        this.codec.setInputStream(in);
        this.conf = conf;
        this.initRegistries();
    }

    public Class getClassForName(String name) throws ClassNotFoundException {
        return this.codec.classForName(name);
    }

    void initRegistries() {
        this.ignoreAnnotations = this.conf.getCLInfoRegistry().isIgnoreAnnotations();
        this.clInfoRegistry = this.conf.getCLInfoRegistry();
        this.objects = (FSTObjectRegistry)this.conf.getCachedObject(FSTObjectRegistry.class);
        if (this.objects == null) {
            this.objects = new FSTObjectRegistry(this.conf);
        } else {
            this.objects.clearForRead();
        }
    }

    public ConditionalCallback getConditionalCallback() {
        return this.conditionalCallback;
    }

    public void setConditionalCallback(ConditionalCallback conditionalCallback) {
        this.conditionalCallback = conditionalCallback;
    }

    public int getReadExternalReadAHead() {
        return this.readExternalReadAHead;
    }

    public void setReadExternalReadAHead(int readExternalReadAHead) {
        this.readExternalReadAHead = readExternalReadAHead;
    }

    @Override
    public Object readObject() throws ClassNotFoundException, IOException {
        try {
            return this.readObject(null);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public int read() throws IOException {
        return this.codec.readFByte();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.codec.readPlainBytes(b, 0, b.length);
        return b.length;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.codec.readPlainBytes(b, off, len);
        return b.length;
    }

    @Override
    public long skip(long n) throws IOException {
        this.codec.skip((int)n);
        return n;
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    void processValidation() throws InvalidObjectException {
        if (this.callbacks == null) {
            return;
        }
        Collections.sort(this.callbacks, new Comparator<CallbackEntry>(){

            @Override
            public int compare(CallbackEntry o1, CallbackEntry o2) {
                return o2.prio - o1.prio;
            }
        });
        for (int i = 0; i < this.callbacks.size(); ++i) {
            CallbackEntry callbackEntry = this.callbacks.get(i);
            try {
                callbackEntry.cb.validateObject();
                continue;
            }
            catch (Exception ex) {
                throw FSTUtil.rethrow(ex);
            }
        }
    }

    public Object readObject(Class ... possibles) throws Exception {
        ++this.curDepth;
        if (this.conf.isCrossPlatform()) {
            return this.readObjectInternal(null);
        }
        try {
            if (possibles != null && possibles.length > 1) {
                for (int i = 0; i < possibles.length; ++i) {
                    Class possible = possibles[i];
                    this.codec.registerClass(possible);
                }
            }
            Object res = this.readObjectInternal(possibles);
            this.processValidation();
            Object object = res;
            return object;
        }
        catch (Throwable th) {
            throw FSTUtil.rethrow(th);
        }
        finally {
            --this.curDepth;
        }
    }

    public Object readObjectInternal(Class ... expected) throws ClassNotFoundException, IOException, IllegalAccessException, InstantiationException {
        try {
            FSTClazzInfo.FSTFieldInfo info = this.infoCache;
            this.infoCache = null;
            if (info == null) {
                info = new FSTClazzInfo.FSTFieldInfo(expected, null, this.ignoreAnnotations);
            } else {
                info.possibleClasses = expected;
            }
            Object res = this.readObjectWithHeader(info);
            this.infoCache = info;
            return res;
        }
        catch (Throwable t) {
            throw FSTUtil.rethrow(t);
        }
    }

    public Object readObjectWithHeader(FSTClazzInfo.FSTFieldInfo referencee) throws Exception {
        Class c;
        FSTClazzInfo clzSerInfo;
        int readPos = this.codec.getInputPos();
        byte code = this.codec.readObjectHeaderTag();
        if (code == 0) {
            clzSerInfo = this.readClass();
            c = clzSerInfo.getClazz();
            if (c.isArray()) {
                return this.readArrayNoHeader(referencee, readPos, c);
            }
        } else if (code == -3) {
            c = referencee.getType();
            clzSerInfo = this.getClazzInfo(c, referencee);
        } else if (code >= 1) {
            c = referencee.getPossibleClasses()[code - 1];
            clzSerInfo = this.getClazzInfo(c, referencee);
        } else {
            return this.instantiateSpecialTag(referencee, readPos, code);
        }
        try {
            FSTObjectSerializer ser = clzSerInfo.getSer();
            if (ser != null) {
                return this.instantiateAndReadWithSer(c, ser, clzSerInfo, referencee, readPos);
            }
            return this.instantiateAndReadNoSer(c, clzSerInfo, referencee, readPos);
        }
        catch (Exception e) {
            throw FSTUtil.rethrow(e);
        }
    }

    private Object instantiateSpecialTag(FSTClazzInfo.FSTFieldInfo referencee, int readPos, byte code) throws Exception {
        if (code == -4) {
            String res = this.codec.readStringUTF();
            this.objects.registerObjectForRead(res, readPos);
            return res;
        }
        if (code == -6) {
            return this.instantiateEnum(referencee, readPos);
        }
        if (code == -1) {
            return null;
        }
        switch (code) {
            case -9: {
                return this.instantiateBigInt();
            }
            case -10: {
                return new Long(this.codec.readFLong());
            }
            case -17: {
                return Boolean.FALSE;
            }
            case -16: {
                return Boolean.TRUE;
            }
            case -18: {
                return referencee.getOneOf()[this.codec.readFByte()];
            }
            case -1: {
                return null;
            }
            case -2: {
                Object directObject = this.codec.getDirectObject();
                if (directObject.getClass() == byte[].class && referencee != null && referencee.getType() == boolean[].class) {
                    byte[] ba = (byte[])directObject;
                    boolean[] res = new boolean[ba.length];
                    for (int i = 0; i < res.length; ++i) {
                        res[i] = ba[i] != 0;
                    }
                    directObject = res;
                }
                this.objects.registerObjectForRead(directObject, readPos);
                return directObject;
            }
            case -4: {
                return this.codec.readStringUTF();
            }
            case -7: {
                return this.instantiateHandle(referencee);
            }
            case -5: {
                return this.instantiateArray(referencee, readPos);
            }
            case -6: {
                return this.instantiateEnum(referencee, readPos);
            }
        }
        throw new RuntimeException("unknown object tag " + code);
    }

    private FSTClazzInfo getClazzInfo(Class c, FSTClazzInfo.FSTFieldInfo referencee) {
        FSTClazzInfo lastInfo = referencee.lastInfo;
        FSTClazzInfo clzSerInfo = lastInfo != null && lastInfo.clazz == c ? lastInfo : this.clInfoRegistry.getCLInfo(c);
        return clzSerInfo;
    }

    private Object instantiateHandle(FSTClazzInfo.FSTFieldInfo referencee) throws IOException {
        int handle = this.codec.readFInt();
        Object res = this.objects.getReadRegisteredObject(handle);
        if (res == null) {
            throw new IOException("unable to ressolve handle " + handle + " " + referencee.getDesc() + " " + this.codec.getInputPos());
        }
        return res;
    }

    private Object instantiateArray(FSTClazzInfo.FSTFieldInfo referencee, int readPos) throws Exception {
        Object res = this.readArray(referencee);
        if (!referencee.isFlat()) {
            this.objects.registerObjectForRead(res, readPos);
        }
        return res;
    }

    private Object instantiateEnum(FSTClazzInfo.FSTFieldInfo referencee, int readPos) throws IOException, ClassNotFoundException {
        FSTClazzInfo clzSerInfo = this.readClass();
        Class c = clzSerInfo.getClazz();
        int ordinal = this.codec.readFInt();
        Object[] enumConstants = clzSerInfo.getEnumConstants();
        if (enumConstants == null) {
            return null;
        }
        Object res = enumConstants[ordinal];
        if (!referencee.isFlat()) {
            this.objects.registerObjectForRead(res, readPos);
        }
        return res;
    }

    private Object instantiateBigInt() throws IOException {
        int val = this.codec.readFInt();
        if (val >= 0 && val < FSTConfiguration.intObjects.length) {
            return FSTConfiguration.intObjects[val];
        }
        return new Integer(val);
    }

    private Object instantiateAndReadWithSer(Class c, FSTObjectSerializer ser, FSTClazzInfo clzSerInfo, FSTClazzInfo.FSTFieldInfo referencee, int readPos) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        boolean serInstance = false;
        Object newObj = ser.instantiate(c, this, clzSerInfo, referencee, readPos);
        if (newObj == null) {
            newObj = clzSerInfo.newInstance(this.codec.isMapBased());
        } else {
            serInstance = true;
        }
        if (newObj == null) {
            throw new IOException(referencee.getDesc() + ":Failed to instantiate '" + c.getName() + "'. Register a custom serializer implementing instantiate.");
        }
        if (newObj.getClass() != c && ser == null) {
            c = newObj.getClass();
            clzSerInfo = this.clInfoRegistry.getCLInfo(c);
        }
        if (!(referencee.isFlat() || clzSerInfo.isFlat() || ser.alwaysCopy())) {
            this.objects.registerObjectForRead(newObj, readPos);
        }
        if (!serInstance) {
            ser.readObject(this, newObj, clzSerInfo, referencee);
        }
        this.codec.consumeEndMarker();
        return newObj;
    }

    protected Object instantiateAndReadNoSer(Class c, FSTClazzInfo clzSerInfo, FSTClazzInfo.FSTFieldInfo referencee, int readPos) throws Exception {
        Object newObj = clzSerInfo.newInstance(this.codec.isMapBased());
        if (newObj == null) {
            throw new IOException(referencee.getDesc() + ":Failed to instantiate '" + c.getName() + "'. Register a custom serializer implementing instantiate.");
        }
        if (!referencee.isFlat() && !clzSerInfo.isFlat()) {
            this.objects.registerObjectForRead(newObj, readPos);
        }
        if (clzSerInfo.isExternalizable()) {
            this.codec.ensureReadAhead(this.readExternalReadAHead);
            ((Externalizable)newObj).readExternal(this);
            this.codec.readExternalEnd();
        } else if (clzSerInfo.useCompatibleMode()) {
            Object replaced = this.readObjectCompatible(referencee, clzSerInfo, newObj);
            if (replaced != null && replaced != newObj) {
                this.objects.replace(newObj, replaced, readPos);
                newObj = replaced;
            }
        } else {
            FSTClazzInfo.FSTFieldInfo[] fieldInfo = clzSerInfo.getFieldInfo();
            this.readObjectFields(referencee, clzSerInfo, fieldInfo, newObj, 0, 0);
        }
        return newObj;
    }

    protected Object readObjectCompatible(FSTClazzInfo.FSTFieldInfo referencee, FSTClazzInfo serializationInfo, Object newObj) throws Exception {
        Class cl = serializationInfo.getClazz();
        this.readObjectCompatibleRecursive(referencee, newObj, serializationInfo, cl);
        if (newObj != null && serializationInfo.getReadResolveMethod() != null) {
            Object rep = null;
            try {
                rep = serializationInfo.getReadResolveMethod().invoke(newObj, new Object[0]);
            }
            catch (InvocationTargetException e) {
                throw FSTUtil.rethrow(e);
            }
            newObj = rep;
        }
        return newObj;
    }

    protected void readObjectCompatibleRecursive(FSTClazzInfo.FSTFieldInfo referencee, Object toRead, FSTClazzInfo serializationInfo, Class cl) throws Exception {
        FSTClazzInfo.FSTCompatibilityInfo fstCompatibilityInfo = serializationInfo.compInfo.get(cl);
        if (!Serializable.class.isAssignableFrom(cl)) {
            return;
        }
        this.readObjectCompatibleRecursive(referencee, toRead, serializationInfo, cl.getSuperclass());
        if (fstCompatibilityInfo != null && fstCompatibilityInfo.getReadMethod() != null) {
            try {
                byte tag = this.readByte();
                if (tag == 66) {
                    this.codec.moveTo(this.codec.getInputPos() - 1);
                }
                ObjectInputStream objectInputStream = this.getObjectInputStream(cl, serializationInfo, referencee, toRead);
                fstCompatibilityInfo.getReadMethod().invoke(toRead, objectInputStream);
                this.fakeWrapper.pop();
            }
            catch (Exception e) {
                throw FSTUtil.rethrow(e);
            }
        } else if (fstCompatibilityInfo != null) {
            byte tag = this.readByte();
            if (tag == 55) {
                tag = this.readByte();
            }
            this.readObjectFields(referencee, serializationInfo, fstCompatibilityInfo.getFieldArray(), toRead, 0, 0);
        }
    }

    public void defaultReadObject(FSTClazzInfo.FSTFieldInfo referencee, FSTClazzInfo serializationInfo, Object newObj) {
        try {
            this.readObjectFields(referencee, serializationInfo, serializationInfo.getFieldInfo(), newObj, 0, 0);
        }
        catch (Exception e) {
            throw FSTUtil.rethrow(e);
        }
    }

    void readObjectFields(FSTClazzInfo.FSTFieldInfo referencee, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo[] fieldInfo, Object newObj, int startIndex, int version) throws Exception {
        if (this.codec.isMapBased()) {
            this.readFieldsMapBased(referencee, serializationInfo, newObj);
            return;
        }
        int booleanMask = 0;
        int boolcount = 8;
        int length = fieldInfo.length;
        int conditional = 0;
        for (int i = startIndex; i < length; ++i) {
            try {
                FSTClazzInfo.FSTFieldInfo subInfo = fieldInfo[i];
                if (subInfo.getVersion() > version) {
                    int nextVersion = this.codec.readVersionTag();
                    if (nextVersion == 0) {
                        this.oldVersionRead(newObj);
                        return;
                    }
                    if (nextVersion != subInfo.getVersion()) {
                        throw new RuntimeException("read version tag " + nextVersion + " fieldInfo has " + subInfo.getVersion());
                    }
                    this.readObjectFields(referencee, serializationInfo, fieldInfo, newObj, i, nextVersion);
                    return;
                }
                if (subInfo.isPrimitive()) {
                    int integralType = subInfo.getIntegralType();
                    if (integralType == 1) {
                        if (boolcount == 8) {
                            booleanMask = this.codec.readFByte() + 256 & 0xFF;
                            boolcount = 0;
                        }
                        boolean val = (booleanMask & 0x80) != 0;
                        booleanMask <<= 1;
                        ++boolcount;
                        subInfo.setBooleanValue(newObj, val);
                        continue;
                    }
                    switch (integralType) {
                        case 2: {
                            subInfo.setByteValue(newObj, this.codec.readFByte());
                            break;
                        }
                        case 3: {
                            subInfo.setCharValue(newObj, this.codec.readFChar());
                            break;
                        }
                        case 4: {
                            subInfo.setShortValue(newObj, this.codec.readFShort());
                            break;
                        }
                        case 5: {
                            subInfo.setIntValue(newObj, this.codec.readFInt());
                            break;
                        }
                        case 6: {
                            subInfo.setLongValue(newObj, this.codec.readFLong());
                            break;
                        }
                        case 7: {
                            subInfo.setFloatValue(newObj, this.codec.readFFloat());
                            break;
                        }
                        case 8: {
                            subInfo.setDoubleValue(newObj, this.codec.readFDouble());
                        }
                    }
                    continue;
                }
                if (subInfo.isConditional() && conditional == 0 && this.skipConditional(newObj, conditional = this.codec.readPlainInt(), subInfo)) {
                    this.codec.moveTo(conditional);
                    continue;
                }
                Object subObject = this.readObjectWithHeader(subInfo);
                subInfo.setObjectValue(newObj, subObject);
                continue;
            }
            catch (IllegalAccessException ex) {
                throw new IOException(ex);
            }
        }
        this.codec.readVersionTag();
    }

    public VersionConflictListener getVersionConflictListener() {
        return this.versionConflictListener;
    }

    public void setVersionConflictListener(VersionConflictListener versionConflictListener) {
        this.versionConflictListener = versionConflictListener;
    }

    protected void oldVersionRead(Object newObj) {
        if (this.versionConflictListener != null) {
            this.versionConflictListener.onOldVersionRead(newObj);
        }
    }

    protected void readFieldsMapBased(FSTClazzInfo.FSTFieldInfo referencee, FSTClazzInfo serializationInfo, Object newObj) throws Exception {
        int len = this.codec.getObjectHeaderLen();
        if (len < 0) {
            len = Integer.MAX_VALUE;
        }
        block10: for (int count = 0; count < len; ++count) {
            String name = this.codec.readStringUTF();
            if (len == Integer.MAX_VALUE && this.codec.isEndMarker(name)) {
                return;
            }
            FSTClazzInfo.FSTFieldInfo fieldInfo = serializationInfo.getFieldInfo(name, null);
            if (fieldInfo == null) {
                System.out.println("warning: unknown field: " + name + " on class " + serializationInfo.getClazz().getName());
                continue;
            }
            if (fieldInfo.isPrimitive()) {
                switch (fieldInfo.getIntegralType()) {
                    case 1: {
                        fieldInfo.setBooleanValue(newObj, this.codec.readFByte() != 0);
                        continue block10;
                    }
                    case 2: {
                        fieldInfo.setByteValue(newObj, this.codec.readFByte());
                        continue block10;
                    }
                    case 3: {
                        fieldInfo.setCharValue(newObj, this.codec.readFChar());
                        continue block10;
                    }
                    case 4: {
                        fieldInfo.setShortValue(newObj, this.codec.readFShort());
                        continue block10;
                    }
                    case 5: {
                        fieldInfo.setIntValue(newObj, this.codec.readFInt());
                        continue block10;
                    }
                    case 6: {
                        fieldInfo.setLongValue(newObj, this.codec.readFLong());
                        continue block10;
                    }
                    case 7: {
                        fieldInfo.setFloatValue(newObj, this.codec.readFFloat());
                        continue block10;
                    }
                    case 8: {
                        fieldInfo.setDoubleValue(newObj, this.codec.readFDouble());
                        continue block10;
                    }
                }
                throw new RuntimeException("unkown primitive type " + fieldInfo);
            }
            Object toSet = this.readObjectWithHeader(fieldInfo);
            fieldInfo.setObjectValue(newObj, toSet);
        }
    }

    private boolean skipConditional(Object newObj, int conditional, FSTClazzInfo.FSTFieldInfo subInfo) {
        if (this.conditionalCallback != null) {
            return this.conditionalCallback.shouldSkip(newObj, conditional, subInfo.getField());
        }
        return false;
    }

    protected void readCompatibleObjectFields(FSTClazzInfo.FSTFieldInfo referencee, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo[] fieldInfo, Map res) throws Exception {
        int booleanMask = 0;
        int boolcount = 8;
        for (int i = 0; i < fieldInfo.length; ++i) {
            try {
                FSTClazzInfo.FSTFieldInfo subInfo = fieldInfo[i];
                if (subInfo.isIntegral() && !subInfo.isArray()) {
                    Class subInfoType = subInfo.getType();
                    if (subInfoType == Boolean.TYPE) {
                        if (boolcount == 8) {
                            booleanMask = this.codec.readFByte() + 256 & 0xFF;
                            boolcount = 0;
                        }
                        boolean val = (booleanMask & 0x80) != 0;
                        booleanMask <<= 1;
                        ++boolcount;
                        res.put(subInfo.getField().getName(), val);
                    }
                    if (subInfoType == Byte.TYPE) {
                        res.put(subInfo.getField().getName(), this.codec.readFByte());
                        continue;
                    }
                    if (subInfoType == Character.TYPE) {
                        res.put(subInfo.getField().getName(), Character.valueOf(this.codec.readFChar()));
                        continue;
                    }
                    if (subInfoType == Short.TYPE) {
                        res.put(subInfo.getField().getName(), this.codec.readFShort());
                        continue;
                    }
                    if (subInfoType == Integer.TYPE) {
                        res.put(subInfo.getField().getName(), this.codec.readFInt());
                        continue;
                    }
                    if (subInfoType == Double.TYPE) {
                        res.put(subInfo.getField().getName(), this.codec.readFDouble());
                        continue;
                    }
                    if (subInfoType == Float.TYPE) {
                        res.put(subInfo.getField().getName(), Float.valueOf(this.codec.readFFloat()));
                        continue;
                    }
                    if (subInfoType != Long.TYPE) continue;
                    res.put(subInfo.getField().getName(), this.codec.readFLong());
                    continue;
                }
                Object subObject = this.readObjectWithHeader(subInfo);
                res.put(subInfo.getField().getName(), subObject);
                continue;
            }
            catch (IllegalAccessException ex) {
                throw new IOException(ex);
            }
        }
    }

    final void ensureReadAhead(int bytes) throws IOException {
        this.codec.ensureReadAhead(bytes);
    }

    public String readStringUTF() throws IOException {
        return this.codec.readStringUTF();
    }

    public String readStringAsc() throws IOException {
        return this.codec.readStringAsc();
    }

    protected Object readArray(FSTClazzInfo.FSTFieldInfo referencee) throws Exception {
        int pos = this.codec.getInputPos();
        Class arrCl = this.codec.readArrayHeader();
        if (arrCl == null) {
            return null;
        }
        return this.readArrayNoHeader(referencee, pos, arrCl);
    }

    private Object readArrayNoHeader(FSTClazzInfo.FSTFieldInfo referencee, int pos, Class arrCl) throws Exception {
        int len = this.codec.readFInt();
        if (len == -1) {
            return null;
        }
        Class<?> arrType = arrCl.getComponentType();
        if (!arrCl.getComponentType().isArray()) {
            Object array = Array.newInstance(arrType, len);
            if (!referencee.isFlat()) {
                this.objects.registerObjectForRead(array, pos);
            }
            if (arrCl.getComponentType().isPrimitive()) {
                return this.codec.readFPrimitiveArray(array, arrType, len);
            }
            Object[] arr = (Object[])array;
            for (int i = 0; i < len; ++i) {
                Object value;
                arr[i] = value = this.readObjectWithHeader(referencee);
            }
            return array;
        }
        Object[] array = (Object[])Array.newInstance(arrType, len);
        if (!referencee.isFlat()) {
            this.objects.registerObjectForRead(array, pos);
        }
        FSTClazzInfo.FSTFieldInfo ref1 = new FSTClazzInfo.FSTFieldInfo(referencee.getPossibleClasses(), null, this.clInfoRegistry.isIgnoreAnnotations());
        for (int i = 0; i < len; ++i) {
            Object subArray;
            array[i] = subArray = this.readArray(ref1);
        }
        return array;
    }

    public void registerObject(Object o, int streamPosition, FSTClazzInfo info, FSTClazzInfo.FSTFieldInfo referencee) {
        if (!(this.objects.disabled || referencee.isFlat() || info != null && info.isFlat())) {
            this.objects.registerObjectForRead(o, streamPosition);
        }
    }

    public FSTClazzInfo readClass() throws IOException, ClassNotFoundException {
        return this.codec.readClass();
    }

    void resetAndClearRefs() {
        try {
            this.reset();
            this.objects.clearForRead();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void reset() throws IOException {
        this.codec.reset();
    }

    public void resetForReuse(InputStream in) throws IOException {
        if (this.closed) {
            throw new RuntimeException("can't reuse closed stream");
        }
        this.codec.reset();
        this.codec.setInputStream(in);
        this.objects.clearForRead();
    }

    public void resetForReuseCopyArray(byte[] bytes, int off, int len) throws IOException {
        if (this.closed) {
            throw new RuntimeException("can't reuse closed stream");
        }
        this.codec.reset();
        this.objects.clearForRead();
        this.codec.resetToCopyOf(bytes, off, len);
    }

    public void resetForReuseUseArray(byte[] bytes) throws IOException {
        this.resetForReuseUseArray(bytes, bytes.length);
    }

    public void resetForReuseUseArray(byte[] bytes, int len) throws IOException {
        if (this.closed) {
            throw new RuntimeException("can't reuse closed stream");
        }
        this.objects.clearForRead();
        this.codec.resetWith(bytes, len);
    }

    public final int readFInt() throws IOException {
        return this.codec.readFInt();
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        this.resetAndClearRefs();
        this.conf.returnObject(this.objects);
        this.codec.close();
    }

    ObjectInputStream getObjectInputStream(final Class cl, final FSTClazzInfo clInfo, final FSTClazzInfo.FSTFieldInfo referencee, final Object toRead) throws IOException {
        ObjectInputStream wrapped = new ObjectInputStream(){
            HashMap<String, Object> fieldMap;

            @Override
            public Object readObjectOverride() throws IOException, ClassNotFoundException {
                try {
                    return FSTObjectInput.this.readObjectInternal(referencee.getPossibleClasses());
                }
                catch (IllegalAccessException e) {
                    throw new IOException(e);
                }
                catch (InstantiationException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public Object readUnshared() throws IOException, ClassNotFoundException {
                try {
                    return FSTObjectInput.this.readObjectInternal(referencee.getPossibleClasses());
                }
                catch (IllegalAccessException e) {
                    throw new IOException(e);
                }
                catch (InstantiationException e) {
                    throw new IOException(e);
                }
            }

            @Override
            public void defaultReadObject() throws IOException, ClassNotFoundException {
                try {
                    byte tag = this.readByte();
                    if (tag == 77) {
                        this.fieldMap = (HashMap)FSTObjectInput.this.readObjectInternal(HashMap.class);
                    } else {
                        FSTObjectInput.this.readObjectFields(referencee, clInfo, clInfo.compInfo.get(cl).getFieldArray(), toRead, 0, 0);
                    }
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }

            @Override
            public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
                byte tag = this.readByte();
                try {
                    FSTClazzInfo.FSTCompatibilityInfo fstCompatibilityInfo = clInfo.compInfo.get(cl);
                    if (tag == 99) {
                        this.fieldMap = new HashMap();
                        FSTObjectInput.this.readCompatibleObjectFields(referencee, clInfo, fstCompatibilityInfo.getFieldArray(), this.fieldMap);
                    } else {
                        this.fieldMap = (HashMap)FSTObjectInput.this.readObjectInternal(HashMap.class);
                    }
                }
                catch (Exception e) {
                    throw FSTUtil.rethrow(e);
                }
                return new ObjectInputStream.GetField(){

                    @Override
                    public ObjectStreamClass getObjectStreamClass() {
                        return ObjectStreamClass.lookup(cl);
                    }

                    @Override
                    public boolean defaulted(String name) throws IOException {
                        return fieldMap.get(name) == null;
                    }

                    @Override
                    public boolean get(String name, boolean val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return (Boolean)fieldMap.get(name);
                    }

                    @Override
                    public byte get(String name, byte val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return (Byte)fieldMap.get(name);
                    }

                    @Override
                    public char get(String name, char val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return ((Character)fieldMap.get(name)).charValue();
                    }

                    @Override
                    public short get(String name, short val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return (Short)fieldMap.get(name);
                    }

                    @Override
                    public int get(String name, int val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return (Integer)fieldMap.get(name);
                    }

                    @Override
                    public long get(String name, long val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return (Long)fieldMap.get(name);
                    }

                    @Override
                    public float get(String name, float val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return ((Float)fieldMap.get(name)).floatValue();
                    }

                    @Override
                    public double get(String name, double val) throws IOException {
                        if (fieldMap.get(name) == null) {
                            return val;
                        }
                        return (Double)fieldMap.get(name);
                    }

                    @Override
                    public Object get(String name, Object val) throws IOException {
                        Object res = fieldMap.get(name);
                        if (res == null) {
                            return val;
                        }
                        return res;
                    }
                };
            }

            @Override
            public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
                if (FSTObjectInput.this.callbacks == null) {
                    FSTObjectInput.this.callbacks = new ArrayList();
                }
                FSTObjectInput.this.callbacks.add(new CallbackEntry(obj, prio));
            }

            @Override
            public int read() throws IOException {
                FSTObjectInput.this.codec.ensureReadAhead(1);
                return FSTObjectInput.this.codec.readFByte();
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                return FSTObjectInput.this.read(buf, off, len);
            }

            @Override
            public int available() throws IOException {
                return FSTObjectInput.this.available();
            }

            @Override
            public void close() throws IOException {
            }

            @Override
            public boolean readBoolean() throws IOException {
                return FSTObjectInput.this.readBoolean();
            }

            @Override
            public byte readByte() throws IOException {
                return FSTObjectInput.this.codec.readFByte();
            }

            @Override
            public int readUnsignedByte() throws IOException {
                return FSTObjectInput.this.readUnsignedByte();
            }

            @Override
            public char readChar() throws IOException {
                return FSTObjectInput.this.codec.readFChar();
            }

            @Override
            public short readShort() throws IOException {
                return FSTObjectInput.this.codec.readFShort();
            }

            @Override
            public int readUnsignedShort() throws IOException {
                return FSTObjectInput.this.readUnsignedShort();
            }

            @Override
            public int readInt() throws IOException {
                return FSTObjectInput.this.codec.readFInt();
            }

            @Override
            public long readLong() throws IOException {
                return FSTObjectInput.this.codec.readFLong();
            }

            @Override
            public float readFloat() throws IOException {
                return FSTObjectInput.this.codec.readFFloat();
            }

            @Override
            public double readDouble() throws IOException {
                return FSTObjectInput.this.codec.readFDouble();
            }

            @Override
            public void readFully(byte[] buf) throws IOException {
                FSTObjectInput.this.readFully(buf);
            }

            @Override
            public void readFully(byte[] buf, int off, int len) throws IOException {
                FSTObjectInput.this.readFully(buf, off, len);
            }

            @Override
            public int skipBytes(int len) throws IOException {
                return FSTObjectInput.this.skipBytes(len);
            }

            @Override
            public String readUTF() throws IOException {
                return FSTObjectInput.this.codec.readStringUTF();
            }

            @Override
            public String readLine() throws IOException {
                return FSTObjectInput.this.readLine();
            }

            @Override
            public int read(byte[] b) throws IOException {
                return FSTObjectInput.this.read(b);
            }

            @Override
            public long skip(long n) throws IOException {
                return FSTObjectInput.this.skip(n);
            }

            @Override
            public void mark(int readlimit) {
                throw new RuntimeException("not implemented");
            }

            @Override
            public void reset() throws IOException {
                FSTObjectInput.this.reset();
            }

            @Override
            public boolean markSupported() {
                return false;
            }
        };
        if (this.fakeWrapper == null) {
            this.fakeWrapper = new MyObjectStream();
        }
        this.fakeWrapper.push(wrapped);
        return this.fakeWrapper;
    }

    static class MyObjectStream
    extends ObjectInputStream {
        ObjectInputStream wrapped;
        ObjectInputStream[] wrappedArr = new ObjectInputStream[30];
        int idx = 0;

        public void push(ObjectInputStream in) {
            this.wrappedArr[this.idx++] = in;
            this.wrapped = in;
        }

        public void pop() {
            --this.idx;
            this.wrapped = this.wrappedArr[this.idx];
        }

        MyObjectStream() throws IOException, SecurityException {
            this.wrapped = this.wrapped;
        }

        @Override
        public Object readObjectOverride() throws IOException, ClassNotFoundException {
            return this.wrapped.readObject();
        }

        @Override
        public Object readUnshared() throws IOException, ClassNotFoundException {
            return this.wrapped.readUnshared();
        }

        @Override
        public void defaultReadObject() throws IOException, ClassNotFoundException {
            this.wrapped.defaultReadObject();
        }

        @Override
        public ObjectInputStream.GetField readFields() throws IOException, ClassNotFoundException {
            return this.wrapped.readFields();
        }

        @Override
        public void registerValidation(ObjectInputValidation obj, int prio) throws NotActiveException, InvalidObjectException {
            this.wrapped.registerValidation(obj, prio);
        }

        @Override
        public int read() throws IOException {
            return this.wrapped.read();
        }

        @Override
        public int read(byte[] buf, int off, int len) throws IOException {
            return this.wrapped.read(buf, off, len);
        }

        @Override
        public int available() throws IOException {
            return this.wrapped.available();
        }

        @Override
        public void close() throws IOException {
            this.wrapped.close();
        }

        @Override
        public boolean readBoolean() throws IOException {
            return this.wrapped.readBoolean();
        }

        @Override
        public byte readByte() throws IOException {
            return this.wrapped.readByte();
        }

        @Override
        public int readUnsignedByte() throws IOException {
            return this.wrapped.readUnsignedByte();
        }

        @Override
        public char readChar() throws IOException {
            return this.wrapped.readChar();
        }

        @Override
        public short readShort() throws IOException {
            return this.wrapped.readShort();
        }

        @Override
        public int readUnsignedShort() throws IOException {
            return this.wrapped.readUnsignedShort();
        }

        @Override
        public int readInt() throws IOException {
            return this.wrapped.readInt();
        }

        @Override
        public long readLong() throws IOException {
            return this.wrapped.readLong();
        }

        @Override
        public float readFloat() throws IOException {
            return this.wrapped.readFloat();
        }

        @Override
        public double readDouble() throws IOException {
            return this.wrapped.readDouble();
        }

        @Override
        public void readFully(byte[] buf) throws IOException {
            this.wrapped.readFully(buf);
        }

        @Override
        public void readFully(byte[] buf, int off, int len) throws IOException {
            this.wrapped.readFully(buf, off, len);
        }

        @Override
        public int skipBytes(int len) throws IOException {
            return this.wrapped.skipBytes(len);
        }

        @Override
        public String readUTF() throws IOException {
            return this.wrapped.readUTF();
        }

        @Override
        public String readLine() throws IOException {
            return this.wrapped.readLine();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.wrapped.read(b);
        }

        @Override
        public long skip(long n) throws IOException {
            return this.wrapped.skip(n);
        }

        @Override
        public void mark(int readlimit) {
            this.wrapped.mark(readlimit);
        }

        @Override
        public void reset() throws IOException {
            this.wrapped.reset();
        }

        @Override
        public boolean markSupported() {
            return this.wrapped.markSupported();
        }
    }

    public static interface ConditionalCallback {
        public boolean shouldSkip(Object var1, int var2, Field var3);
    }

    static class CallbackEntry {
        ObjectInputValidation cb;
        int prio;

        CallbackEntry(ObjectInputValidation cb, int prio) {
            this.cb = cb;
            this.prio = prio;
        }
    }
}

