/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization.serializers;

import de.ruedigermoeller.heapoff.bytez.onheap.HeapBytez;
import de.ruedigermoeller.heapoff.structs.FSTStruct;
import de.ruedigermoeller.heapoff.structs.unsafeimpl.FSTStructFactory;
import de.ruedigermoeller.serialization.FSTBasicObjectSerializer;
import de.ruedigermoeller.serialization.FSTClazzInfo;
import de.ruedigermoeller.serialization.FSTObjectInput;
import de.ruedigermoeller.serialization.FSTObjectOutput;
import java.io.IOException;

public class FSTStructSerializer
extends FSTBasicObjectSerializer {
    public static boolean COMPRESS = true;

    public void writeObject(FSTObjectOutput out, Object toWrite, FSTClazzInfo clzInfo, FSTClazzInfo.FSTFieldInfo referencedBy, int streamPosition) throws IOException {
        FSTStruct str = (FSTStruct)toWrite;
        if (!str.isOffHeap()) {
            str = str.toOffHeap();
        }
        int byteSize = str.getByteSize();
        out.writeFInt(byteSize);
        if (COMPRESS) {
            long base = str.___offset;
            int intsiz = byteSize / 4;
            for (int i = 0; i < intsiz; ++i) {
                int value = str.getInt();
                value = value << 1 ^ value >> 31;
                str.___offset += 4L;
                while ((long)(value & 0xFFFFFF80) != 0L) {
                    out.writeFByte(value & 0x7F | 0x80);
                    value >>>= 7;
                }
                out.writeFByte(value & 0x7F);
            }
            int remainder = byteSize & 3;
            for (int i = 0; i < remainder; ++i) {
                byte aByte = str.getByte();
                out.writeFByte(aByte);
                ++str.___offset;
            }
            str.___offset = base;
        } else {
            byte[] b = new byte[byteSize];
            str.getBase().getArr(str.getOffset(), b, 0, byteSize);
            out.write(b, 0, byteSize);
        }
    }

    public Object instantiate(Class objectClass, FSTObjectInput in, FSTClazzInfo serializationInfo, FSTClazzInfo.FSTFieldInfo referencee, int streamPositioin) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        int len = in.readFInt();
        byte[] bytes = new byte[len];
        if (COMPRESS) {
            int intsiz = len / 4;
            int count = 0;
            for (int n = 0; n < intsiz; ++n) {
                byte b;
                int value = 0;
                int i = 0;
                while (((b = in.readFByte()) & 0x80) != 0) {
                    value |= (b & 0x7F) << i;
                    i += 7;
                }
                int temp = ((value |= b << i) << 31 >> 31 ^ value) >> 1;
                value = temp ^ value & Integer.MIN_VALUE;
                bytes[count++] = (byte)(value >>> 0 & 0xFF);
                bytes[count++] = (byte)(value >>> 8 & 0xFF);
                bytes[count++] = (byte)(value >>> 16 & 0xFF);
                bytes[count++] = (byte)(value >>> 24 & 0xFF);
            }
            int remainder = len & 3;
            for (int i = 0; i < remainder; ++i) {
                bytes[count++] = in.readFByte();
            }
        } else {
            in.read(bytes);
        }
        HeapBytez hb = new HeapBytez(bytes);
        return FSTStructFactory.getInstance().createStructWrapper(hb, 0);
    }
}

