/*
 * Decompiled with CFR 0.152.
 */
package de.ruedigermoeller.serialization.dson;

import java.lang.reflect.Array;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DsonTypeMapper {
    protected HashMap<String, Class> typeMap = new HashMap();
    protected HashMap<String, String> impliedMap = new HashMap();
    protected HashMap<Class, String> reverseTypeMap = new HashMap();
    protected DateFormat dateTimeInstance = DateFormat.getDateTimeInstance();

    public DsonTypeMapper() {
        this.map("map", HashMap.class);
    }

    public Class getType(String type) {
        Class<?> res = this.typeMap.get(type);
        if (res == null) {
            try {
                res = Class.forName(type);
            }
            catch (ClassNotFoundException e) {
                return null;
            }
        }
        return res;
    }

    public String getStringForType(Class c) {
        String res = this.reverseTypeMap.get(c);
        if (res == null) {
            return c.getName();
        }
        return res;
    }

    public DsonTypeMapper implyAttrFromType(String type, String attr) {
        this.impliedMap.put(type, attr);
        return this;
    }

    public DsonTypeMapper map(String name, Class c) {
        this.typeMap.put(name, c);
        if (this.reverseTypeMap.get(c) == null) {
            this.reverseTypeMap.put(c, name);
        }
        return this;
    }

    public DsonTypeMapper map(Class ... c) {
        for (int i = 0; i < c.length; ++i) {
            Class aClass = c[i];
            this.map(aClass.getSimpleName(), aClass);
        }
        return this;
    }

    public Object coerceReading(Class type, Object readObject) {
        if (Map.class.isAssignableFrom(type) && readObject.getClass().isArray()) {
            try {
                Map c = (Map)type.newInstance();
                int len = Array.getLength(readObject);
                for (int i = 0; i < len; i += 2) {
                    c.put(Array.get(readObject, i), Array.get(readObject, i + 1));
                }
                return c;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (Collection.class.isAssignableFrom(type) && readObject.getClass().isArray()) {
            try {
                Collection c = (Collection)type.newInstance();
                int len = Array.getLength(readObject);
                for (int i = 0; i < len; ++i) {
                    c.add(Array.get(readObject, i));
                }
                return c;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (Date.class.isAssignableFrom(type) && readObject instanceof String) {
            try {
                return this.dateTimeInstance.parse((String)readObject);
            }
            catch (ParseException pe) {
                pe.printStackTrace();
            }
        }
        return readObject;
    }

    public Object coerceWriting(Object objectValue) {
        if (objectValue instanceof Map) {
            Object[] result = new Object[((Map)objectValue).size() * 2];
            int i = 0;
            for (Map.Entry next : ((Map)objectValue).entrySet()) {
                result[i] = this.coerceWriting(next.getKey());
                result[i + 1] = this.coerceWriting(next.getValue());
                i += 2;
            }
            return result;
        }
        if (objectValue instanceof Collection) {
            return ((Collection)objectValue).toArray();
        }
        if (objectValue instanceof Date) {
            return this.dateTimeInstance.format((Date)objectValue);
        }
        return objectValue;
    }

    public DateFormat getDateTimeInstance() {
        return this.dateTimeInstance;
    }

    public void setDateTimeInstance(DateFormat dateTimeInstance) {
        this.dateTimeInstance = dateTimeInstance;
    }

    public Object mapLiteral(String type) {
        if (type.equals("true") || type.equals("yes") || type.equals("y")) {
            return Boolean.TRUE;
        }
        if (type.equals("false") || type.equals("no") || type.equals("n")) {
            return Boolean.FALSE;
        }
        return null;
    }

    public String getImpliedAttr(Class mappedClass, String type) {
        return this.impliedMap.get(type);
    }
}

