/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import de.mhus.lib.core.lang.NullValue;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class NullableMap<K, V>
implements Map<K, V> {
    private static final NullValue NULL_VALUE = new NullValue();
    private HashMap<K, Object> impl = new HashMap();

    @Override
    public int size() {
        return this.impl.size();
    }

    @Override
    public boolean isEmpty() {
        return this.impl.isEmpty();
    }

    @Override
    public V get(Object key) {
        Object ret = this.impl.get(key);
        if (ret instanceof NullValue) {
            return null;
        }
        return (V)ret;
    }

    @Override
    public boolean equals(Object o) {
        return this.impl.equals(o);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.impl.containsKey(key);
    }

    @Override
    public V put(K key, V value) {
        if (value == null) {
            Object ret = this.impl.put(key, NULL_VALUE);
            if (ret instanceof NullValue) {
                return null;
            }
            return (V)ret;
        }
        Object ret = this.impl.put(key, value);
        if (ret instanceof NullValue) {
            return null;
        }
        return (V)ret;
    }

    @Override
    public int hashCode() {
        return this.impl.hashCode();
    }

    public String toString() {
        return this.impl.toString();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        this.impl.putAll(m);
    }

    @Override
    public V remove(Object key) {
        Object ret = this.impl.remove(key);
        if (ret instanceof NullValue) {
            return null;
        }
        return (V)ret;
    }

    @Override
    public void clear() {
        this.impl.clear();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.impl.containsValue(value);
    }

    public Object clone() {
        return this.impl.clone();
    }

    @Override
    public Set<K> keySet() {
        return this.impl.keySet();
    }

    @Override
    public Collection<V> values() {
        LinkedList<Object> out = new LinkedList<Object>();
        for (Object o : this.impl.values()) {
            if (o instanceof NullValue) continue;
            out.add(o);
        }
        return out;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        LinkedList<MyEntry> out = new LinkedList<MyEntry>();
        for (Map.Entry<K, Object> o : this.impl.entrySet()) {
            if (o instanceof NullValue) continue;
            out.add(new MyEntry(o));
        }
        return (Set)((Object)out);
    }

    private class MyEntry
    implements Map.Entry<K, V> {
        private K k;
        private Object v;

        public MyEntry(Map.Entry<K, Object> o) {
            this.k = o.getKey();
            this.v = o.getValue();
        }

        @Override
        public K getKey() {
            return this.k;
        }

        @Override
        public V getValue() {
            if (this.v instanceof NullValue) {
                return null;
            }
            return this.v;
        }

        @Override
        public V setValue(V value) {
            return null;
        }
    }
}

