/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

public class ByteBufferArray {
    int extend = 10240;
    int next = 0;
    byte[] buffer = null;

    public ByteBufferArray() {
        this.buffer = new byte[this.extend];
    }

    public ByteBufferArray(int initial) {
        this.buffer = new byte[initial];
    }

    public ByteBufferArray(int initial, int extend) {
        this.buffer = new byte[initial];
        this.extend = extend;
    }

    public void append(byte in) {
        if (this.next >= this.buffer.length) {
            byte[] newBuffer = new byte[this.buffer.length + this.extend];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        this.buffer[this.next] = in;
        ++this.next;
    }

    public void append(byte[] in) {
        this.append(in, 0, in.length);
    }

    public void append(byte[] in, int offset, int len) {
        if (this.next + len > this.buffer.length) {
            byte[] newBuffer = new byte[this.buffer.length + Math.max(this.extend, len)];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
        try {
            System.arraycopy(in, offset, this.buffer, this.next, len);
        }
        catch (IndexOutOfBoundsException ioe) {
            System.out.println("FATAL: ByteBufferArray.append: " + in.length + ' ' + offset + ' ' + this.buffer.length + ' ' + this.next + ' ' + len);
            throw ioe;
        }
        this.next += len;
    }

    public int getSize() {
        return this.next;
    }

    public byte[] toByte() {
        byte[] newBuffer = new byte[this.next];
        System.arraycopy(this.buffer, 0, newBuffer, 0, this.next);
        return newBuffer;
    }

    public boolean isCurrentlyFull() {
        return this.next == this.buffer.length;
    }

    public byte[] getInternalBuffer() {
        return this.buffer;
    }

    public void clear() {
        this.buffer = new byte[0];
        this.next = 0;
    }
}

