/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.util;

import java.util.LinkedList;

public class ByteBuffer {
    private int extend = 10240;
    private LinkedList<byte[]> list = new LinkedList();
    private byte[] last = null;
    private int lastPos = 0;
    private byte[] buffer = new byte[1];
    private int size = 0;

    public ByteBuffer() {
    }

    public ByteBuffer(int extend) {
        if (extend < 1) {
            throw new RuntimeException("Extend to less");
        }
        this.extend = extend;
    }

    public void append(byte in) {
        this.buffer[0] = in;
        this.append(this.buffer, 0, 1);
    }

    public void append(byte[] in) {
        this.append(in, 0, in.length);
    }

    public void append(byte[] in, int offset, int len) {
        if (this.last == null) {
            this.last = new byte[Math.max(this.extend, len)];
            this.list.addLast(this.last);
            this.lastPos = 0;
        }
        while (len > 0) {
            if (len < this.last.length - this.lastPos) {
                System.arraycopy(in, offset, this.last, this.lastPos, len);
                this.lastPos += len;
                this.size += len;
                len = 0;
                continue;
            }
            int max = this.last.length - this.lastPos;
            System.arraycopy(in, offset, this.last, this.lastPos, max);
            offset += max;
            len -= max;
            this.size += max;
            this.last = null;
        }
    }

    public int getSize() {
        return this.size;
    }

    public byte[] toByte() {
        byte[] out = new byte[this.size];
        int pos = 0;
        for (byte[] part : this.list) {
            int len = part.length;
            if (pos + len >= out.length) {
                len = out.length - pos;
            }
            System.arraycopy(part, 0, out, pos, len);
        }
        return out;
    }

    public void clear() {
        this.list.clear();
        this.size = 0;
    }
}

