/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.system;

import de.mhus.lib.core.MActivator;
import de.mhus.lib.core.MSingleton;
import de.mhus.lib.core.MString;
import de.mhus.lib.core.MTimer;
import de.mhus.lib.core.activator.ActivatorImpl;
import de.mhus.lib.core.config.HashConfig;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.config.XmlConfigFile;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.core.io.FileWatch;
import de.mhus.lib.core.lang.BaseControl;
import de.mhus.lib.core.logging.ConsoleFactory;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.LogFactory;
import de.mhus.lib.core.service.ConfigProvider;
import de.mhus.lib.core.system.ISingleton;
import de.mhus.lib.core.system.SingletonInitialize;
import java.io.File;
import java.util.HashSet;

public class DefaultSingleton
implements ISingleton,
SingletonInitialize {
    private ConsoleFactory logFactory;
    private File baseDir;
    private IConfig config;
    private BaseControl baseControl;
    private ConfigProvider configProvider;
    private boolean fullTrace;
    private HashSet<String> logTrace = new HashSet();
    private FileWatch fileWatch;
    private boolean needFileWatch = false;
    private String configFile;

    @Override
    public Log createLog(Object owner) {
        String name = null;
        name = owner == null ? "?" : (owner instanceof Class ? ((Class)owner).getName() : String.valueOf(owner));
        return this.logFactory.getInstance(name);
    }

    @Override
    public void doInitialize(ClassLoader coreLoader) {
        this.needFileWatch = "true".equals(System.getProperty("mhus.config.watch"));
        this.configFile = System.getProperty("mhus.config.file", "mhus-config.xml");
        this.logFactory = new ConsoleFactory();
        this.baseDir = new File(".");
    }

    public synchronized IConfig getConfig() {
        if (this.config == null) {
            if (this.fileWatch != null) {
                this.fileWatch.doStop();
                this.fileWatch = null;
            }
            File f = new File(this.baseDir, this.configFile);
            if (MSingleton.isDirtyTrace()) {
                System.out.println("--- Try to load mhus config from " + f.getAbsolutePath());
            }
            this.internalLoadConfig(f);
            if (this.needFileWatch) {
                MTimer timer = this.baseControl.getCurrentBase().base(MTimer.class);
                this.fileWatch = new FileWatch(f, timer, new FileWatch.Listener(){

                    @Override
                    public void onFileChanged(FileWatch fileWatch) {
                        File file = fileWatch.getFile();
                        DefaultSingleton.this.internalLoadConfig(file);
                        DefaultSingleton.this.logFactory.updateLoggers();
                    }

                    @Override
                    public void onFileWatchError(FileWatch fileWatch, Throwable t) {
                        if (MSingleton.isDirtyTrace()) {
                            t.printStackTrace();
                        }
                    }
                }).doStart();
            }
        }
        return this.config;
    }

    private void internalLoadConfig(File file) {
        block4: {
            if (file.exists() && file.isFile()) {
                try {
                    this.config = new XmlConfigFile(file);
                }
                catch (Exception e) {
                    if (!this.fullTrace) break block4;
                    e.printStackTrace();
                }
            }
        }
        if (this.config == null) {
            this.config = new HashConfig();
        }
        this.loadConfig();
    }

    private void loadConfig() {
        block5: {
            ResourceNode system = this.config.getNode("system");
            if (system == null) {
                return;
            }
            this.fullTrace = system.getBoolean("TRACE", false);
            this.logTrace.clear();
            for (String p : system.getPropertyKeys()) {
                if (!p.startsWith("TRACE.")) continue;
                this.logTrace.add(p.substring(6));
            }
            try {
                String factoryClassName = system.getString("log.factory.class");
                if (MString.isSet(factoryClassName)) {
                    this.logFactory = (ConsoleFactory)Class.forName(factoryClassName).newInstance();
                }
            }
            catch (Throwable t) {
                if (!this.fullTrace) break block5;
                t.printStackTrace();
            }
        }
    }

    @Override
    public synchronized BaseControl getBaseControl() {
        if (this.baseControl == null) {
            this.baseControl = new BaseControl();
        }
        return this.baseControl;
    }

    @Override
    public MActivator createActivator() {
        return new ActivatorImpl();
    }

    @Override
    public LogFactory getLogFactory() {
        return this.logFactory;
    }

    @Override
    public synchronized ConfigProvider getConfigProvider() {
        if (this.configProvider == null) {
            this.configProvider = new ConfigProvider(this.getConfig());
        }
        return this.configProvider;
    }

    @Override
    public boolean isTrace(String name) {
        return this.fullTrace || this.logTrace.contains(name);
    }
}

