/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.strategy;

import de.mhus.lib.core.MThread;
import de.mhus.lib.core.strategy.ExecuteStrategy;
import de.mhus.lib.core.strategy.Operation;
import de.mhus.lib.core.strategy.TaskContext;
import java.util.concurrent.TimeoutException;

public class WaitExecuteStrategy
extends ExecuteStrategy {
    private Operation executable;
    private long waitTime;
    private long timeout;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doExecute(TaskContext context) throws Exception {
        if (this.executable == null) {
            return;
        }
        try {
            long cnt = this.timeout;
            while (!this.executable.setBusy(this)) {
                MThread.sleep(this.waitTime);
                if (cnt <= 0L || (cnt -= this.waitTime) > 0L) continue;
                throw new TimeoutException("timeout");
            }
            if (this.executable == null) {
                return;
            }
            this.executable.doExecute(context);
        }
        finally {
            if (this.executable != null) {
                this.executable.releaseBusy(this);
            }
        }
    }

    @Override
    public Operation getExecutable() {
        return this.executable;
    }

    @Override
    public void setExecutable(Operation executable) {
        this.executable = executable;
    }

    public long getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(long waitTime) {
        this.waitTime = waitTime;
    }
}

