/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.pojo;

import de.mhus.lib.core.pojo.DefaultFilter;
import de.mhus.lib.core.pojo.PojoAttribute;
import de.mhus.lib.core.pojo.PojoModel;
import de.mhus.lib.core.pojo.PojoParser;
import java.io.IOException;
import java.util.UUID;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.node.ObjectNode;

public class MPojo {
    public static void pojoToJson(Object from, ObjectNode to) throws IOException {
        PojoModel model = new PojoParser().parse(from, "_", null).filter(new DefaultFilter(true, false, true, false, true)).getModel();
        for (PojoAttribute attr : model) {
            Object value = attr.get(from);
            String name = attr.getName();
            if (value == null) {
                to.put(name, (String)null);
                continue;
            }
            if (value instanceof Boolean) {
                to.put(name, ((Boolean)value).booleanValue());
                continue;
            }
            if (value instanceof Integer) {
                to.put(name, ((Integer)value).intValue());
                continue;
            }
            if (value instanceof String) {
                to.put(name, (String)value);
                continue;
            }
            if (value.getClass().isEnum()) {
                to.put(name, ((Enum)value).ordinal());
                to.put(name + "_", ((Enum)value).name());
                continue;
            }
            to.put(attr.getName(), String.valueOf(value));
        }
    }

    public static void jsonToPojo(JsonNode from, Object to) throws IOException {
        PojoModel model = new PojoParser().parse(to, "_", null).filter(new DefaultFilter(true, false, false, false, true)).getModel();
        for (PojoAttribute attr : model) {
            String name = attr.getName();
            Class<?> type = attr.getType();
            JsonNode json = from.get(name);
            try {
                if (json == null || !attr.canWrite()) continue;
                if (type == Boolean.class || type == Boolean.TYPE) {
                    attr.set(to, json.getValueAsBoolean(false));
                    continue;
                }
                if (type == Integer.class || type == Integer.TYPE) {
                    attr.set(to, json.getValueAsInt(0));
                    continue;
                }
                if (type == String.class) {
                    attr.set(to, json.getValueAsText());
                    continue;
                }
                if (type == UUID.class) {
                    try {
                        attr.set(to, UUID.fromString(json.getValueAsText()));
                    }
                    catch (IllegalArgumentException e) {
                        attr.set(to, null);
                    }
                    continue;
                }
                if (type.isEnum()) {
                    Object c;
                    ?[] cons = type.getEnumConstants();
                    int ord = json.getValueAsInt(0);
                    Object t = c = cons.length > 0 ? (Object)cons[0] : null;
                    if (ord >= 0 && ord < cons.length) {
                        c = cons[ord];
                    }
                    attr.set(to, c);
                    continue;
                }
                attr.set(to, json.getValueAsText());
            }
            catch (Throwable t) {
                System.out.println("ERROR " + name);
                t.printStackTrace();
            }
        }
    }
}

