/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.pojo;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.pojo.PojoAttribute;
import de.mhus.lib.core.pojo.PojoParser;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

public class FunctionAttribute<T>
implements PojoAttribute<T> {
    private Class<T> clazz;
    private Method getter;
    private Method setter;
    private String name;
    private FunctionAttribute<Object> parent;

    public FunctionAttribute(Class<T> clazz, Method getter, Method setter, String name, FunctionAttribute<Object> parent) {
        this.clazz = clazz;
        this.getter = getter;
        this.setter = setter;
        this.name = name;
        this.parent = parent;
    }

    @Override
    public Class<T> getManagedClass() {
        return this.clazz;
    }

    @Override
    public boolean canRead() {
        return this.getter != null;
    }

    @Override
    public boolean canWrite() {
        return this.setter != null;
    }

    @Override
    public Class<T> getType() {
        if (this.getter != null) {
            return this.getter.getReturnType();
        }
        return this.setter.getParameterTypes()[0];
    }

    @Override
    public void set(Object pojo, T value) throws IOException {
        pojo = PojoParser.checkParent(this.parent, pojo);
        if (this.setter == null) {
            throw new IOException("Method is read only: " + this.getter.getName());
        }
        try {
            value = MCast.toType(value, this.getType(), null);
            if (this.getType().isPrimitive() && value == null) {
                value = MCast.getDefaultPrimitive(this.getType());
            }
            this.setter.invoke(pojo, value);
        }
        catch (Exception e) {
            throw new IOException("Error set: " + this.name + "(" + this.getType() + ")=" + value, e);
        }
    }

    @Override
    public T get(Object pojo) throws IOException {
        pojo = PojoParser.checkParent(this.parent, pojo);
        try {
            return (T)this.getter.invoke(pojo, new Object[0]);
        }
        catch (Exception e) {
            throw new IOException("Error get: " + this.name + "(" + this.clazz + ")", e);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<? extends A> annotationClass) {
        A out;
        A a = out = this.getter == null ? null : (A)this.getter.getAnnotation(annotationClass);
        if (out == null && this.setter != null) {
            out = this.setter.getAnnotation(annotationClass);
        }
        return out;
    }

    public String toString() {
        return "[" + this.name + "@FunctionAttribute]";
    }
}

