/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.pojo;

import de.mhus.lib.annotations.base.IgnoreBind;
import de.mhus.lib.annotations.pojo.Embedded;
import de.mhus.lib.core.MCast;
import de.mhus.lib.core.lang.MObject;
import de.mhus.lib.core.pojo.PojoAttribute;
import de.mhus.lib.core.pojo.PojoModelImpl;
import de.mhus.lib.core.pojo.PojoParser;
import de.mhus.lib.core.pojo.PojoStrategy;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.LinkedList;

@IgnoreBind
public class AttributesStrategy
extends MObject
implements PojoStrategy {
    private boolean embedded;
    private String embedGlue;
    private boolean toLower;
    private Class<? extends Annotation>[] annotationMarker;

    public AttributesStrategy() {
        this(true, true, ".", null);
    }

    public AttributesStrategy(boolean embedded, boolean toLower, String embedGlue, Class<? extends Annotation>[] annotationMarker) {
        this.embedded = embedded;
        this.toLower = toLower;
        this.embedGlue = embedGlue;
        this.annotationMarker = annotationMarker;
    }

    @Override
    public void parseObject(PojoParser parser, Object pojo, PojoModelImpl model) {
        if (pojo instanceof Class) {
            this.parse(parser, (Class)pojo, model);
        } else {
            this.parseObject(parser, pojo.getClass(), model);
        }
    }

    @Override
    public void parse(PojoParser parser, Class<?> clazz, PojoModelImpl model) {
        this.parse("", null, parser, clazz, model);
    }

    protected void parse(String prefix, Attribute<Object> parent, PojoParser parser, Class<?> clazz, PojoModelImpl model) {
        for (Field field : this.getAttributes(clazz)) {
            if (Modifier.isStatic(field.getModifiers()) || Modifier.isFinal(field.getModifiers()) || field.isAccessible()) continue;
            try {
                field.setAccessible(true);
            }
            catch (Throwable t) {
                this.log().i("setAccessible", field.getDeclaringClass().getCanonicalName(), field.getName(), t);
            }
            if (!field.isAccessible() || !this.isMarker(field) && !this.isEmbedded(field)) continue;
            String name = field.getName();
            String s = this.toLower ? name.toLowerCase() : name;
            name = prefix + s;
            Attribute<Object> attr = new Attribute<Object>(name, parent, field);
            if (this.isEmbedded(field)) {
                this.parse(name + this.embedGlue, attr, parser, attr.getType(), model);
                continue;
            }
            if (model.hasAttribute(name)) continue;
            model.addAttribute(attr);
        }
    }

    protected boolean isEmbedded(Field field) {
        if (!this.embedded) {
            return false;
        }
        return field.isAnnotationPresent(Embedded.class);
    }

    protected boolean isMarker(Field field) {
        if (this.annotationMarker == null) {
            return true;
        }
        for (Class<? extends Annotation> a : this.annotationMarker) {
            if (!field.isAnnotationPresent(a)) continue;
            return true;
        }
        return false;
    }

    protected LinkedList<Field> getAttributes(Class<?> clazz) {
        LinkedList<Field> out = new LinkedList<Field>();
        do {
            for (Field field : clazz.getDeclaredFields()) {
                out.add(field);
            }
        } while ((clazz = clazz.getSuperclass()) != null);
        return out;
    }

    class Attribute<T>
    implements PojoAttribute<T> {
        private Field field;
        private String name;
        private Attribute<Object> parent;

        public Attribute(String name, Attribute<Object> parent, Field field) {
            this.name = name;
            this.field = field;
            this.parent = parent;
        }

        @Override
        public T get(Object pojo) throws IOException {
            try {
                pojo = PojoParser.checkParent(this.parent, pojo);
                if (!this.field.isAccessible()) {
                    this.field.setAccessible(true);
                }
                return (T)this.field.get(pojo);
            }
            catch (Exception e) {
                throw new IOException(this.field.getName(), e);
            }
        }

        @Override
        public void set(Object pojo, T value) throws IOException {
            try {
                pojo = PojoParser.checkParent(this.parent, pojo);
                if (!this.field.isAccessible()) {
                    this.field.setAccessible(true);
                }
                value = MCast.toType(value, this.getType(), null);
                if (this.getType().isPrimitive() && value == null) {
                    value = MCast.getDefaultPrimitive(this.getType());
                }
                this.field.set(pojo, value);
            }
            catch (Exception e) {
                throw new IOException(this.field.getName(), e);
            }
        }

        @Override
        public Class<?> getType() {
            return this.field.getType();
        }

        @Override
        public boolean canRead() {
            return true;
        }

        @Override
        public boolean canWrite() {
            return true;
        }

        @Override
        public Class<T> getManagedClass() {
            return this.field.getDeclaringClass();
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public <A extends Annotation> A getAnnotation(Class<? extends A> annotationClass) {
            return this.field.getAnnotation(annotationClass);
        }
    }
}

