/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.parser;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.parser.CompiledString;
import de.mhus.lib.core.parser.Parser;
import de.mhus.lib.core.parser.StringPart;
import java.util.LinkedList;
import java.util.Map;

public class StringCompiler
implements Parser {
    private static StringCompiler defaultCompiler = new StringCompiler();
    protected String separator = "$";

    public static CompiledString compile(String in) {
        return StringCompiler.compile(in, defaultCompiler);
    }

    public static CompiledString compile(String in, StringCompiler compiler) {
        return compiler.compileString(in);
    }

    @Override
    public CompiledString compileString(String in) {
        LinkedList<StringPart> compiled = new LinkedList<StringPart>();
        String[] parts = MString.split(in, this.separator);
        boolean c = true;
        for (String part : parts) {
            if (c) {
                compiled.add(this.createContentPart(part));
                c = false;
                continue;
            }
            if (part.length() == 0) {
                compiled.add(this.createContentPart(this.separator));
            } else {
                compiled.add(this.createAttributePart(part));
            }
            c = true;
        }
        return new CompiledString(compiled);
    }

    protected StringPart createAttributePart(String part) {
        if (part.startsWith("#env.")) {
            return new EnvironmentPart(part);
        }
        if (part.startsWith("#system.")) {
            return new SystemPart(part);
        }
        return this.createDefaultAttributePart(part);
    }

    protected StringPart createDefaultAttributePart(String part) {
        return new AttributePart(part);
    }

    protected StringPart createContentPart(String part) {
        return new ContentPart(part);
    }

    public class AttributePart
    implements StringPart {
        private String name;

        public AttributePart(String part) {
            this.name = part;
        }

        @Override
        public void execute(StringBuffer out, Map<String, Object> attributes) {
            if (attributes != null) {
                out.append(attributes.get(this.name));
            }
        }

        @Override
        public void dump(int level, StringBuffer out) {
            MString.appendRepeating(level, ' ', out);
            out.append(this.getClass().getCanonicalName()).append(" ").append(this.name).append("\n");
        }
    }

    public class SystemPart
    implements StringPart {
        private String name;

        public SystemPart(String part) {
            this.name = MString.afterIndex(part, '.');
        }

        @Override
        public void execute(StringBuffer out, Map<String, Object> attributes) {
            out.append(System.getProperty(this.name));
        }

        @Override
        public void dump(int level, StringBuffer out) {
            MString.appendRepeating(level, ' ', out);
            out.append(this.getClass().getCanonicalName()).append(" ").append(this.name).append("\n");
        }
    }

    public class EnvironmentPart
    implements StringPart {
        private String name;

        public EnvironmentPart(String part) {
            this.name = MString.afterIndex(part, '.');
        }

        @Override
        public void execute(StringBuffer out, Map<String, Object> attributes) {
            out.append(System.getenv(this.name));
        }

        @Override
        public void dump(int level, StringBuffer out) {
            MString.appendRepeating(level, ' ', out);
            out.append(this.getClass().getCanonicalName()).append(" ").append(this.name);
        }
    }

    public class ContentPart
    implements StringPart {
        private String content;

        public ContentPart(String part) {
            this.content = part;
        }

        @Override
        public void execute(StringBuffer out, Map<String, Object> attributes) {
            out.append(this.content);
        }

        @Override
        public void dump(int level, StringBuffer out) {
            MString.appendRepeating(level, ' ', out);
            out.append(this.getClass().getCanonicalName()).append(" ").append(this.content).append("\n");
        }
    }
}

