/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.logging;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.logging.Log;
import java.io.PrintWriter;
import java.util.Date;

public class PrintWriterLog
extends Log {
    private PrintWriter out;
    private String name;
    private boolean printTime = true;
    private Log.LEVEL level = Log.LEVEL.TRACE;
    private boolean traces = true;

    public PrintWriterLog(String name, PrintWriter writer) {
        super(name);
        this.out = writer;
    }

    @Override
    public void debug(Object message) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.out.println(this.printTime() + "DEBUG: " + this.name + " " + message);
        if (message != null && message instanceof Throwable) {
            ((Throwable)message).printStackTrace(this.out);
        }
    }

    @Override
    public void debug(Object message, Throwable t) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.out.println(this.printTime() + "DEBUG: " + this.name + " " + message);
        if (t != null && this.traces) {
            t.printStackTrace(this.out);
        }
    }

    @Override
    public void error(Object message) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.out.println(this.printTime() + "ERROR: " + this.name + " " + message);
        if (message != null && message instanceof Throwable && this.traces) {
            ((Throwable)message).printStackTrace(this.out);
        }
    }

    @Override
    public void error(Object message, Throwable t) {
        if (!this.isErrorEnabled()) {
            return;
        }
        this.out.println(this.printTime() + "ERROR: " + this.name + " " + message);
        if (t != null && this.traces) {
            t.printStackTrace(this.out);
        }
    }

    @Override
    public void fatal(Object message) {
        if (!this.isFatalEnabled()) {
            return;
        }
        this.out.println(this.printTime() + "FATAL: " + this.name + " " + message);
        if (message != null && message instanceof Throwable && this.traces) {
            ((Throwable)message).printStackTrace(this.out);
        }
    }

    @Override
    public void fatal(Object message, Throwable t) {
        if (!this.isFatalEnabled()) {
            return;
        }
        this.out.println(this.printTime() + "FATAL: " + this.name + " " + message);
        if (t != null && this.traces) {
            t.printStackTrace(this.out);
        }
    }

    @Override
    public void info(Object message) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.out.println(this.printTime() + "INFO : " + this.name + " " + message);
        if (message != null && message instanceof Throwable && this.traces) {
            ((Throwable)message).printStackTrace(this.out);
        }
    }

    @Override
    public void info(Object message, Throwable t) {
        if (!this.isInfoEnabled()) {
            return;
        }
        this.out.println(this.printTime() + "INFO : " + this.name + " " + message);
        if (t != null && this.traces) {
            t.printStackTrace(this.out);
        }
    }

    @Override
    public boolean isDebugEnabled() {
        return this.isTrace() || this.level.ordinal() <= Log.LEVEL.DEBUG.ordinal();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.isTrace() || this.level.ordinal() <= Log.LEVEL.ERROR.ordinal();
    }

    @Override
    public boolean isFatalEnabled() {
        return this.isTrace() || this.level.ordinal() <= Log.LEVEL.FATAL.ordinal();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.isTrace() || this.level.ordinal() <= Log.LEVEL.INFO.ordinal();
    }

    @Override
    public boolean isTraceEnabled() {
        return this.isTrace() || this.level.ordinal() <= Log.LEVEL.TRACE.ordinal();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.isTrace() || this.level.ordinal() <= Log.LEVEL.WARN.ordinal();
    }

    @Override
    public void trace(Object message) {
        if (this.isTrace()) {
            this.out.println(this.printTime() + "TRACE: " + this.name + " " + message);
            if (message != null && message instanceof Throwable && this.traces) {
                ((Throwable)message).printStackTrace(this.out);
            }
        }
    }

    @Override
    public void trace(Object message, Throwable t) {
        if (!this.isTrace()) {
            return;
        }
        this.out.println(this.printTime() + "TRACE: " + this.name + " " + message);
        if (t != null && this.traces) {
            t.printStackTrace(this.out);
        }
    }

    @Override
    public void warn(Object message) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.out.println(this.printTime() + "WARN : " + this.name + " " + message);
        if (message != null && message instanceof Throwable && this.traces) {
            ((Throwable)message).printStackTrace(this.out);
        }
    }

    @Override
    public void warn(Object message, Throwable t) {
        if (!this.isWarnEnabled()) {
            return;
        }
        this.out.println(this.printTime() + "WARN : " + this.name + " " + message);
        if (t != null && this.traces) {
            t.printStackTrace(this.out);
        }
    }

    public String printTime() {
        if (this.printTime) {
            return MCast.toString(new Date()) + " ";
        }
        return "";
    }

    public Log.LEVEL getLevel() {
        return this.level;
    }

    public void setLevel(Log.LEVEL level) {
        this.level = level;
    }

    public boolean isTraces() {
        return this.traces;
    }

    public void setTraces(boolean traces) {
        this.traces = traces;
    }

    public PrintWriter getWriter() {
        return this.out;
    }
}

