/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.logging;

import de.mhus.lib.core.MCast;
import de.mhus.lib.core.MSingleton;
import de.mhus.lib.core.config.IConfig;
import de.mhus.lib.core.console.Console;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.core.logging.Log;
import de.mhus.lib.core.logging.LogFactory;
import de.mhus.lib.errors.MException;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.util.Date;

public class ConsoleFactory
extends LogFactory {
    private PrintStream out;
    private boolean traces = true;
    private boolean printTime = true;
    private ResourceNode config;

    public ConsoleFactory() {
        this.out = System.out;
    }

    @Override
    public Log createInstance(String name) {
        return new ConsoleLog(name);
    }

    public ConsoleFactory(IConfig config) throws Exception {
        this.init(config);
    }

    public String printTime() {
        if (this.printTime) {
            return MCast.toString(new Date()) + " ";
        }
        return "";
    }

    @Override
    public void init(ResourceNode config) throws Exception {
        if (config == null) {
            return;
        }
        this.config = config;
        this.printTime = config.getBoolean("TIME", this.printTime);
        String newLevel = config.getExtracted("LEVEL", this.level.name());
        if (newLevel != null) {
            this.level = Log.LEVEL.valueOf(newLevel.toUpperCase());
        }
        String file = config.getExtracted("file", null);
        String io = config.getExtracted("stream", null);
        this.traces = config.getBoolean("traces", true);
        if (file != null) {
            FileOutputStream f;
            try {
                f = new FileOutputStream(file, config.getBoolean("append", true));
            }
            catch (FileNotFoundException e) {
                throw new MException(new Object[]{file, e});
            }
            this.out = new PrintStream(f, true);
        } else {
            this.out = "console".equals(io) ? (PrintStream)MSingleton.get().getBaseControl().base(this).base(Console.class) : ("err".equals(io) ? System.err : System.out);
        }
    }

    public ConsoleFactory(PrintStream stream) {
        this.out = stream;
    }

    public Log.LEVEL getLevel() {
        return this.level;
    }

    public void setLevel(Log.LEVEL level) {
        this.level = level;
    }

    @Override
    public void updateLoggers() {
        try {
            this.init();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.updateLoggers();
    }

    private class ConsoleLog
    extends Log {
        private String name;

        public ConsoleLog(String name) {
            super(name);
        }

        @Override
        public void debug(Object message) {
            if (!this.isDebugEnabled()) {
                return;
            }
            ConsoleFactory.this.out.println(ConsoleFactory.this.printTime() + "DEBUG: " + this.name + " " + message);
            if (message != null && message instanceof Throwable) {
                ((Throwable)message).printStackTrace(ConsoleFactory.this.out);
            }
        }

        @Override
        public void debug(Object message, Throwable t) {
            if (!this.isDebugEnabled()) {
                return;
            }
            ConsoleFactory.this.out.println(ConsoleFactory.this.printTime() + "DEBUG: " + this.name + " " + message);
            if (t != null && ConsoleFactory.this.traces) {
                t.printStackTrace(ConsoleFactory.this.out);
            }
        }

        @Override
        public void error(Object message) {
            if (!this.isErrorEnabled()) {
                return;
            }
            ConsoleFactory.this.out.println(ConsoleFactory.this.printTime() + "ERROR: " + this.name + " " + message);
            if (message != null && message instanceof Throwable && ConsoleFactory.this.traces) {
                ((Throwable)message).printStackTrace(ConsoleFactory.this.out);
            }
        }

        @Override
        public void error(Object message, Throwable t) {
            if (!this.isErrorEnabled()) {
                return;
            }
            ConsoleFactory.this.out.println(ConsoleFactory.this.printTime() + "ERROR: " + this.name + " " + message);
            if (t != null && ConsoleFactory.this.traces) {
                t.printStackTrace(ConsoleFactory.this.out);
            }
        }

        @Override
        public void fatal(Object message) {
            if (!this.isFatalEnabled()) {
                return;
            }
            ConsoleFactory.this.out.println(ConsoleFactory.this.printTime() + "FATAL: " + this.name + " " + message);
            if (message != null && message instanceof Throwable && ConsoleFactory.this.traces) {
                ((Throwable)message).printStackTrace(ConsoleFactory.this.out);
            }
        }

        @Override
        public void fatal(Object message, Throwable t) {
            if (!this.isFatalEnabled()) {
                return;
            }
            ConsoleFactory.this.out.println(ConsoleFactory.this.printTime() + "FATAL: " + this.name + " " + message);
            if (t != null && ConsoleFactory.this.traces) {
                t.printStackTrace(ConsoleFactory.this.out);
            }
        }

        @Override
        public void info(Object message) {
            if (!this.isInfoEnabled()) {
                return;
            }
            ConsoleFactory.this.out.println(ConsoleFactory.this.printTime() + "INFO : " + this.name + " " + message);
            if (message != null && message instanceof Throwable && ConsoleFactory.this.traces) {
                ((Throwable)message).printStackTrace(ConsoleFactory.this.out);
            }
        }

        @Override
        public void info(Object message, Throwable t) {
            if (!this.isInfoEnabled()) {
                return;
            }
            ConsoleFactory.this.out.println(ConsoleFactory.this.printTime() + "INFO : " + this.name + " " + message);
            if (t != null && ConsoleFactory.this.traces) {
                t.printStackTrace(ConsoleFactory.this.out);
            }
        }

        @Override
        public boolean isDebugEnabled() {
            return this.isTrace() || ConsoleFactory.this.getLevel().ordinal() <= Log.LEVEL.DEBUG.ordinal();
        }

        @Override
        public boolean isErrorEnabled() {
            return this.isTrace() || ConsoleFactory.this.getLevel().ordinal() <= Log.LEVEL.ERROR.ordinal();
        }

        @Override
        public boolean isFatalEnabled() {
            return this.isTrace() || ConsoleFactory.this.getLevel().ordinal() <= Log.LEVEL.FATAL.ordinal();
        }

        @Override
        public boolean isInfoEnabled() {
            return this.isTrace() || ConsoleFactory.this.getLevel().ordinal() <= Log.LEVEL.INFO.ordinal();
        }

        @Override
        public boolean isTraceEnabled() {
            return this.isTrace() || ConsoleFactory.this.getLevel().ordinal() <= Log.LEVEL.TRACE.ordinal();
        }

        @Override
        public boolean isWarnEnabled() {
            return this.isTrace() || ConsoleFactory.this.getLevel().ordinal() <= Log.LEVEL.WARN.ordinal();
        }

        @Override
        public void trace(Object message) {
            if (this.isTrace()) {
                ConsoleFactory.this.out.println(ConsoleFactory.this.printTime() + "TRACE: " + this.name + " " + message);
                if (message != null && message instanceof Throwable && ConsoleFactory.this.traces) {
                    ((Throwable)message).printStackTrace(ConsoleFactory.this.out);
                }
            }
        }

        @Override
        public void trace(Object message, Throwable t) {
            if (!this.isTrace()) {
                return;
            }
            ConsoleFactory.this.out.println(ConsoleFactory.this.printTime() + "TRACE: " + this.name + " " + message);
            if (t != null && ConsoleFactory.this.traces) {
                t.printStackTrace(ConsoleFactory.this.out);
            }
        }

        @Override
        public void warn(Object message) {
            if (!this.isWarnEnabled()) {
                return;
            }
            ConsoleFactory.this.out.println(ConsoleFactory.this.printTime() + "WARN : " + this.name + " " + message);
            if (message != null && message instanceof Throwable && ConsoleFactory.this.traces) {
                ((Throwable)message).printStackTrace(ConsoleFactory.this.out);
            }
        }

        @Override
        public void warn(Object message, Throwable t) {
            if (!this.isWarnEnabled()) {
                return;
            }
            ConsoleFactory.this.out.println(ConsoleFactory.this.printTime() + "WARN : " + this.name + " " + message);
            if (t != null && ConsoleFactory.this.traces) {
                t.printStackTrace(ConsoleFactory.this.out);
            }
        }
    }
}

