/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.lang;

import de.mhus.lib.core.MString;
import de.mhus.lib.core.directory.MResourceProvider;
import de.mhus.lib.core.directory.ResourceNode;
import de.mhus.lib.core.logging.Log;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;

public class DynamicClassLoader
extends ClassLoader {
    public static Log log = Log.getLog(DynamicClassLoader.class);
    protected String name = null;
    protected LinkedList<MResourceProvider> classLoaders = new LinkedList();
    protected Rule[] rules = null;
    protected RESULT defaultRule = RESULT.NEXT;

    public DynamicClassLoader(String name) {
        this.name = name;
    }

    public DynamicClassLoader(String name, ClassLoader parent) {
        super(parent);
        this.name = name;
    }

    public String toString() {
        return this.name;
    }

    public void setRules(List<Rule> list) {
        this.rules = list.toArray(new Rule[list.size()]);
    }

    public void addRule(Rule rule) {
        LinkedList<Rule> list = new LinkedList<Rule>();
        if (this.rules != null) {
            for (Rule r : this.rules) {
                list.add(r);
            }
        }
        list.add(rule);
        this.setRules(list);
    }

    public void setDefaultRule(RESULT rule) {
        this.defaultRule = rule;
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        log.t("ask for", this, name);
        if (this.rules != null) {
            for (Rule rule : this.rules) {
                RESULT res = rule.check(name);
                switch (res) {
                    case OWN: {
                        return this.findAndOwnClass(name);
                    }
                    case FORWARD: {
                        return super.findClass(name);
                    }
                }
            }
        }
        if (this.defaultRule == RESULT.OWN) {
            return this.findAndOwnClass(name);
        }
        if (this.defaultRule == RESULT.FORWARD) {
            return super.findClass(name);
        }
        String resName = name.replaceAll("\\.", "/") + ".class";
        for (MResourceProvider cl : this.classLoaders) {
            try {
                InputStream res = ((ResourceNode)cl.getResource(resName)).getInputStream();
                if (res == null) continue;
                log.t("loaded class", this, cl, name);
                return this.toClass(name, res);
            }
            catch (Exception e) {
                log.t(name, e);
            }
        }
        return super.findClass(name);
    }

    public Class<?> findAndOwnClass(String name) throws ClassNotFoundException {
        if (name.startsWith("java.") || name.startsWith("javax.")) {
            return super.loadClass(name);
        }
        String resName = name.replaceAll("\\.", "/") + ".class";
        for (MResourceProvider cl : this.classLoaders) {
            try {
                InputStream res = ((ResourceNode)cl.getResource(resName)).getInputStream();
                if (res == null) continue;
                log.t("loaded class", this, cl, name);
                return this.toClass(name, res);
            }
            catch (Exception e) {
                log.t(name, e);
            }
        }
        return super.findClass(name);
    }

    private Class<?> toClass(String name, InputStream is) throws ClassNotFoundException {
        try {
            int j;
            ByteArrayOutputStream stream = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[1024];
            while ((j = is.read(buffer, 0, buffer.length)) >= 0) {
                stream.write(buffer, 0, j);
            }
            byte[] binary = stream.toByteArray();
            return this.defineClass(name, binary, 0, binary.length);
        }
        catch (IOException e) {
            throw new ClassNotFoundException(name, e);
        }
    }

    @Override
    protected URL findResource(String name) {
        log.t("resource", this, name);
        for (MResourceProvider cl : this.classLoaders) {
            try {
                URL res = ((ResourceNode)cl.getResource(name)).getUrl();
                if (res == null) continue;
                res.openStream().close();
                log.t("loaded resource", this, cl, name);
                return res;
            }
            catch (Exception e) {
            }
        }
        return super.findResource(name);
    }

    public boolean add(MResourceProvider e) {
        return this.classLoaders.add(e);
    }

    public boolean remove(MResourceProvider o) {
        return this.classLoaders.remove(o);
    }

    public void clear() {
        this.classLoaders.clear();
    }

    public void add(int index, MResourceProvider element) {
        this.classLoaders.add(index, element);
    }

    public static class Rule {
        private String pattern;
        private RESULT result;

        public Rule(String pattern, RESULT result) {
            this.pattern = pattern;
            this.result = result;
        }

        public RESULT check(String name) {
            if (MString.compareFsLikePattern(name, this.pattern)) {
                return this.result;
            }
            return RESULT.NEXT;
        }
    }

    public static enum RESULT {
        NEXT,
        OWN,
        FORWARD;

    }
}

