/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.io;

import de.mhus.lib.core.MFile;
import de.mhus.lib.core.lang.MObject;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class Unzip
extends MObject {
    public void unzip(File src, File dst, FileFilter filter) throws ZipException, IOException {
        ZipFile zipFile = new ZipFile(src);
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            if (entry.isDirectory()) {
                System.err.println("Extracting directory: " + entry.getName());
                new File(entry.getName()).mkdir();
                continue;
            }
            File dstFile = new File(dst, entry.getName());
            if (filter != null && filter.accept(dstFile)) continue;
            this.log().t("Unzip file: " + entry.getName());
            MFile.copyFile(zipFile.getInputStream(entry), new BufferedOutputStream(new FileOutputStream(dstFile)));
        }
        zipFile.close();
    }
}

