/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.io;

import java.io.IOException;
import java.io.InputStream;

public class PartialInputStream
extends InputStream {
    private int max;
    private InputStream src;
    private int cnt;
    private Integer delimiter;

    public PartialInputStream(InputStream pSrc, int length) {
        this.src = pSrc;
        this.max = length;
        this.cnt = 0;
    }

    public void setLength(int length) {
        this.cnt = 0;
        this.max = length;
    }

    public int getBytesLeft() {
        return this.max - this.cnt;
    }

    @Override
    public int read() throws IOException {
        int ret;
        if (this.max >= 0 && this.cnt >= this.max) {
            return -1;
        }
        ++this.cnt;
        if (this.delimiter != null && (ret = this.src.read()) == this.delimiter) {
            this.max = 0;
            this.cnt = 0;
            return -1;
        }
        return this.src.read();
    }

    public void setDelimiter(Integer d) {
        this.delimiter = d;
    }
}

