/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.io;

import java.io.File;
import java.util.Timer;
import java.util.TimerTask;

public class FileWatch
extends TimerTask {
    private File file;
    private Timer timer;
    private long period = 30000L;
    private long size = -2L;
    private Listener listener;

    public FileWatch(File fileToWatch, Timer timer, Listener listener) {
        this(fileToWatch, timer, 30000L, false, listener);
    }

    public FileWatch(File fileToWatch, Timer timer, long period, boolean startHook, Listener listener) {
        this.file = fileToWatch;
        this.timer = timer;
        this.period = period;
        if (startHook) {
            this.size = -3L;
        }
        this.listener = listener;
    }

    public FileWatch doStart() {
        this.timer.schedule((TimerTask)this, 0L, this.period);
        return this;
    }

    public FileWatch doStop() {
        this.cancel();
        return this;
    }

    @Override
    public void run() {
        block9: {
            try {
                long newSize = 0L;
                if (this.file.exists()) {
                    if (this.file.isFile()) {
                        newSize = this.file.length();
                    } else if (this.file.isDirectory()) {
                        for (File f : this.file.listFiles()) {
                            if (!f.isFile() || f.isHidden()) continue;
                            newSize += f.length();
                        }
                    }
                } else {
                    newSize = -1L;
                }
                if (this.size != -2L && this.listener != null) {
                    this.listener.onFileChanged(this);
                }
                this.size = newSize;
            }
            catch (Throwable t) {
                if (this.listener == null) break block9;
                this.listener.onFileWatchError(this, t);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public String toString() {
        return this.file != null ? this.file.getAbsolutePath() : "?";
    }

    public static interface Listener {
        public void onFileChanged(FileWatch var1);

        public void onFileWatchError(FileWatch var1, Throwable var2);
    }
}

