/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core.io;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;

public class CSVReader {
    public static final char NO_QUOTS = '\u0000';
    private static final int AFTER_END_QUOTE = 3;
    private static final boolean DEBUGGING = false;
    private static final int EOL = 0;
    private static final int IN_PLAIN = 1;
    private static final int IN_QUOTED = 2;
    private static final int ORDINARY = 1;
    private static final int QUOTE = 2;
    private static final int SEEKING_START = 0;
    private static final int SEPARATOR = 3;
    private static final int SKIPPING_TAIL = 4;
    private static final int WHITESPACE = 4;
    static String lineSeparator = System.getProperty("line.separator");
    private BufferedReader r;
    private String line = null;
    private boolean allFieldsDone = true;
    private final boolean allowMultiLineFields;
    private final boolean trim;
    private final char quote;
    private final char separator;
    private int lineCount = 0;
    private HashMap<String, Integer> headerIndex;
    private String[] currentLine;

    public CSVReader(Reader r) {
        this(r, ',', '\"', false, true);
    }

    public CSVReader(Reader r, char separator, char quote, boolean allowMultiLineFields, boolean trim) {
        this.r = r instanceof BufferedReader ? (BufferedReader)r : new BufferedReader(r);
        if (this.r == null) {
            throw new IllegalArgumentException("invalid Reader");
        }
        this.separator = separator;
        this.quote = quote;
        this.allowMultiLineFields = allowMultiLineFields;
        this.trim = trim;
    }

    private int categorise(char c) {
        switch (c) {
            case '\t': 
            case '\r': 
            case ' ': 
            case '\u00ff': {
                return 4;
            }
            case '\n': {
                return 0;
            }
        }
        if (c == this.quote) {
            return 2;
        }
        if (c == this.separator) {
            return 3;
        }
        if ('!' <= c && c <= '~') {
            return 1;
        }
        if ('\u0000' <= c && c <= ' ') {
            return 4;
        }
        if (Character.isWhitespace(c)) {
            return 4;
        }
        return 1;
    }

    public void close() throws IOException {
        if (this.r != null) {
            this.r.close();
            this.r = null;
        }
    }

    public String get() throws EOFException, IOException {
        StringBuffer field = new StringBuffer(this.allowMultiLineFields ? 512 : 64);
        int state = 0;
        block40: while (true) {
            this.getLineIfNeeded();
            int i = 0;
            while (true) {
                if (i >= this.line.length()) continue block40;
                char c = this.line.charAt(i);
                int category = this.categorise(c);
                block0 : switch (state) {
                    case 0: {
                        switch (category) {
                            case 4: {
                                break;
                            }
                            case 2: {
                                state = 2;
                                break;
                            }
                            case 3: {
                                this.line = this.line.substring(i + 1);
                                return "";
                            }
                            case 0: {
                                if (this.allFieldsDone) {
                                    this.line = null;
                                    return null;
                                }
                                this.allFieldsDone = true;
                                this.line = this.line.substring(i);
                                return "";
                            }
                            case 1: {
                                field.append(c);
                                state = 1;
                            }
                        }
                        break;
                    }
                    case 1: {
                        switch (category) {
                            case 2: {
                                throw new IOException("Malformed CSV stream. Missing quote at start of field on line " + this.lineCount);
                            }
                            case 3: {
                                this.line = this.line.substring(i + 1);
                                return this.maybeTrim(field.toString());
                            }
                            case 0: {
                                this.line = this.line.substring(i);
                                this.allFieldsDone = true;
                                return this.maybeTrim(field.toString());
                            }
                            case 4: {
                                field.append(' ');
                                break;
                            }
                            case 1: {
                                field.append(c);
                            }
                        }
                        break;
                    }
                    case 2: {
                        switch (category) {
                            case 2: {
                                state = 3;
                                break;
                            }
                            case 0: {
                                if (this.allowMultiLineFields) {
                                    field.append(lineSeparator);
                                    this.line = null;
                                    continue block40;
                                }
                                this.allFieldsDone = true;
                                throw new IOException("Malformed CSV stream. Missing quote (\") after field on line " + this.lineCount);
                            }
                            case 4: {
                                field.append(' ');
                                break;
                            }
                            case 1: 
                            case 3: {
                                field.append(c);
                            }
                        }
                        break;
                    }
                    case 3: {
                        switch (category) {
                            case 2: {
                                field.append(c);
                                state = 2;
                                break block0;
                            }
                            case 3: {
                                this.line = this.line.substring(i + 1);
                                return this.maybeTrim(field.toString());
                            }
                            case 0: {
                                this.line = this.line.substring(i);
                                this.allFieldsDone = true;
                                return this.maybeTrim(field.toString());
                            }
                            case 4: {
                                state = 4;
                                break block0;
                            }
                            case 1: {
                                throw new IOException("Malformed CSV stream, missing separator after fieldon line " + this.lineCount);
                            }
                        }
                        break;
                    }
                    case 4: {
                        switch (category) {
                            case 3: {
                                this.line = this.line.substring(i + 1);
                                return this.maybeTrim(field.toString());
                            }
                            case 0: {
                                this.line = this.line.substring(i);
                                this.allFieldsDone = true;
                                return this.maybeTrim(field.toString());
                            }
                            case 4: {
                                break block0;
                            }
                            case 1: 
                            case 2: {
                                throw new IOException("Malformed CSV stream, missing separator after field on line " + this.lineCount);
                            }
                        }
                    }
                }
                ++i;
            }
            break;
        }
    }

    public String[] getAllFieldsInLine() throws EOFException, IOException {
        String field;
        ArrayList<String> al = new ArrayList<String>(30);
        while ((field = this.get()) != null) {
            al.add(field);
        }
        return al.toArray(new String[al.size()]);
    }

    public double getDouble() throws EOFException, IOException, NumberFormatException {
        String s = this.get();
        if (s == null) {
            return 0.0;
        }
        if (!this.trim) {
            s = s.trim();
        }
        if (s.length() == 0) {
            return 0.0;
        }
        return Double.parseDouble(s);
    }

    public float getFloat() throws EOFException, IOException, NumberFormatException {
        String s = this.get();
        if (s == null) {
            return 0.0f;
        }
        if (!this.trim) {
            s = s.trim();
        }
        if (s.length() == 0) {
            return 0.0f;
        }
        return Float.parseFloat(s);
    }

    public int getInt() throws EOFException, IOException, NumberFormatException {
        String s = this.get();
        if (s == null) {
            return 0;
        }
        if (!this.trim) {
            s = s.trim();
        }
        if (s.length() == 0) {
            return 0;
        }
        return Integer.parseInt(s);
    }

    private void getLineIfNeeded() throws EOFException, IOException {
        if (this.line == null) {
            if (this.r == null) {
                throw new IllegalArgumentException("attempt to use a closed CSVReader");
            }
            this.allFieldsDone = false;
            this.line = this.r.readLine();
            if (this.line == null) {
                throw new EOFException();
            }
            this.line = this.line + '\n';
            ++this.lineCount;
        }
    }

    public long getLong() throws EOFException, IOException, NumberFormatException {
        String s = this.get();
        if (s == null) {
            return 0L;
        }
        if (!this.trim) {
            s = s.trim();
        }
        if (s.length() == 0) {
            return 0L;
        }
        return Long.parseLong(s);
    }

    private String maybeTrim(String s) {
        if (this.trim) {
            return s.trim();
        }
        return s;
    }

    public void skip(int fields) throws EOFException, IOException {
        if (fields <= 0) {
            return;
        }
        for (int i = 0; i < fields; ++i) {
            this.get();
        }
    }

    public void skipToNextLine() throws EOFException, IOException {
        if (this.line == null) {
            this.getLineIfNeeded();
        }
        this.line = null;
    }

    public void readHeader(boolean lower) throws EOFException, IOException {
        this.currentLine = this.getAllFieldsInLine();
        this.headerIndex = new HashMap();
        for (int i = 0; i < this.currentLine.length; ++i) {
            this.headerIndex.put(lower ? this.currentLine[i].toLowerCase() : this.currentLine[i], i);
        }
    }

    public String[] getRowNames() {
        return this.headerIndex.keySet().toArray(new String[this.headerIndex.size()]);
    }

    public boolean next() throws IOException {
        try {
            this.currentLine = this.getAllFieldsInLine();
        }
        catch (EOFException e) {
            return false;
        }
        return true;
    }

    public String get(String row) throws IOException {
        Integer idx = this.headerIndex.get(row);
        if (idx == null) {
            throw new IOException("row not found " + row);
        }
        return this.currentLine[idx];
    }

    public String get(int row) {
        return this.currentLine[row];
    }

    public int getLineCount() {
        return this.lineCount;
    }

    public static void main(String[] args) {
    }

    static {
        if (lineSeparator == null) {
            lineSeparator = "\r012";
        }
    }
}

