/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import de.mhus.lib.core.MProperties;
import de.mhus.lib.errors.MException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;

public class MSql {
    public static String encode(String string, boolean notNull) {
        if (string == null) {
            return notNull ? "' '" : "NULL";
        }
        if (string.indexOf(39) < 0) {
            return '\'' + string + '\'';
        }
        return '\'' + string.replaceAll("'", "''") + '\'';
    }

    public static String escape(String in) {
        if (in == null) {
            return "";
        }
        if (in.indexOf(39) < 0) {
            return in;
        }
        return in.replaceAll("'", "''");
    }

    public static String unescape(String in) {
        if (in == null) {
            return "";
        }
        if (in.indexOf(39) < 0) {
            return in;
        }
        return in.replaceAll("''", "'");
    }

    public static String escape(String in, int truncateSize) {
        if (in == null) {
            return null;
        }
        if (in.length() > truncateSize) {
            in = in.substring(0, truncateSize);
        }
        if (in.indexOf(39) < 0) {
            return in;
        }
        return in.replaceAll("'", "''");
    }

    public static void executeUpdateQueries(Statement sth, String sql) throws SQLException {
        String[] parts = sql.split(";");
        for (int i = 0; i < parts.length; ++i) {
            if (parts[i].trim().length() == 0) continue;
            sth.executeUpdate(parts[i].trim());
        }
    }

    public static String quoteSQL(String sql) {
        StringBuffer sb = new StringBuffer(sql.length() + 5);
        sb.append('\'');
        for (int i = 0; i < sql.length(); ++i) {
            char c = sql.charAt(i);
            if (c == '\'') {
                sb.append("''");
                continue;
            }
            sb.append(c);
        }
        sb.append('\'');
        return sb.toString();
    }

    public static String toSqlLabel(String in, Connection con) {
        boolean error = false;
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if ((c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_') && (i != 0 || c < '0' || c > '9')) continue;
            error = true;
            break;
        }
        if (!error) {
            return in;
        }
        StringBuffer out = new StringBuffer();
        for (int i = 0; i < in.length(); ++i) {
            char c = in.charAt(i);
            if (i == 0 && c >= '0' && c <= '9') {
                out.append('_');
            }
            if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_')) {
                out.append('_');
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static void fillProperties(ResultSet res, MProperties prop) throws SQLException, MException {
        MSql.fillProperties(res, prop, null);
    }

    public static void fillProperties(ResultSet res, MProperties prop, SqlTranslator translator) throws SQLException, MException {
        ResultSetMetaData meta = res.getMetaData();
        if (translator == null) {
            translator = new SqlTranslator();
        }
        block10: for (int i = 1; i < meta.getColumnCount(); ++i) {
            String name = meta.getColumnName(i);
            int type = meta.getColumnType(i);
            switch (type) {
                case -1: 
                case 1: 
                case 12: {
                    translator.toString(res, prop, name, i, type);
                    continue block10;
                }
                case -6: 
                case 2: 
                case 3: 
                case 5: 
                case 7: {
                    translator.toNumber(res, prop, name, i, type);
                    continue block10;
                }
                case -7: {
                    translator.toBoolean(res, prop, name, i, type);
                    continue block10;
                }
                case 4: {
                    translator.toInt(res, prop, name, i, type);
                    continue block10;
                }
                case -5: {
                    translator.toLong(res, prop, name, i, type);
                    continue block10;
                }
                case 6: 
                case 8: {
                    translator.toDouble(res, prop, name, i, type);
                    continue block10;
                }
                case -4: 
                case -3: 
                case -2: 
                case 2005: {
                    translator.toBinary(res, prop, name, i, type);
                    continue block10;
                }
                case 91: 
                case 92: 
                case 93: {
                    translator.toDate(res, prop, name, i, type);
                }
            }
        }
    }

    public static class SqlTranslator {
        public void toString(ResultSet res, MProperties prop, String name, int i, int type) throws MException, SQLException {
            prop.setString(name, res.getString(i));
        }

        public void toDate(ResultSet res, MProperties prop, String name, int i, int type) throws MException, SQLException {
            prop.setDate(name, res.getTimestamp(i));
        }

        public void toBinary(ResultSet res, MProperties prop, String name, int i, int type) throws MException, SQLException {
        }

        public void toDouble(ResultSet res, MProperties prop, String name, int i, int type) throws MException, SQLException {
            prop.setDouble(name, res.getDouble(i));
        }

        public void toLong(ResultSet res, MProperties prop, String name, int i, int type) throws MException, SQLException {
            prop.setLong(name, res.getLong(i));
        }

        public void toInt(ResultSet res, MProperties prop, String name, int i, int type) throws MException, SQLException {
            prop.setInt(name, res.getInt(i));
        }

        public void toBoolean(ResultSet res, MProperties prop, String name, int i, int type) throws MException, SQLException {
            prop.setBoolean(name, res.getBoolean(i));
        }

        public void toNumber(ResultSet res, MProperties prop, String name, int i, int type) throws MException, SQLException {
            prop.setNumber(name, res.getBigDecimal(i));
        }
    }
}

