/*
 * Decompiled with CFR 0.152.
 */
package de.mhus.lib.core;

import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class MCollection {
    public static boolean contains(Object[] array, Object item) {
        if (array == null) {
            return false;
        }
        for (Object o : array) {
            if ((item != null || o != null) && (o == null || !o.equals(item))) continue;
            return true;
        }
        return false;
    }

    public static <T> void copyArray(T[] array, Collection<T> list) {
        if (array == null || list == null) {
            return;
        }
        for (T item : array) {
            if (item == null) continue;
            list.add(item);
        }
    }

    public static <T> void removeDuplicates(List<T> list) {
        HashSet<T> encountered = new HashSet<T>();
        Iterator<T> iter = list.iterator();
        while (iter.hasNext()) {
            T t = iter.next();
            boolean first = encountered.add(t);
            if (first) continue;
            iter.remove();
        }
    }

    public static <T> void removeDuplicates(List<T> list, Comparator<T> comparator) {
        HashSet<T> encountered = new HashSet<T>();
        Iterator<T> iter = list.iterator();
        while (iter.hasNext()) {
            T t = iter.next();
            boolean removed = false;
            for (Object e : encountered) {
                if (comparator.compare(t, e) != 0) continue;
                iter.remove();
                removed = true;
                break;
            }
            if (removed) continue;
            encountered.add(t);
        }
    }
}

