/*
 * Decompiled with CFR 0.152.
 */
package de.jensd.fx.fontawesome.test;

import de.jensd.fx.fontawesome.AwesomeDude;
import de.jensd.fx.fontawesome.AwesomeIcon;
import de.jensd.fx.fontawesome.test.AwesomeIconNameComparator;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.control.Button;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.input.Clipboard;
import javafx.scene.input.ClipboardContent;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;

public class IconsBrowser
extends VBox {
    @FXML
    private ResourceBundle resources;
    @FXML
    private FlowPane iconsBox;
    @FXML
    private HBox headerBox;
    @FXML
    private Label numberOfIconsLabel;
    @FXML
    private ScrollPane iconsScrollPane;

    public IconsBrowser() {
        this.init();
    }

    private void init() {
        try {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("i18n/messages");
            URL fxmlURL = ((Object)((Object)this)).getClass().getResource("/fxml/iconsbrowser.fxml");
            FXMLLoader fxmlLoader = new FXMLLoader(fxmlURL, resourceBundle);
            fxmlLoader.setRoot((Object)this);
            fxmlLoader.setController((Object)this);
            fxmlLoader.load();
        }
        catch (IOException ex) {
            Logger.getLogger(IconsBrowser.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    @FXML
    void initialize() {
        AwesomeIconNameComparator iconNameComparator = new AwesomeIconNameComparator();
        List list = Stream.of(AwesomeIcon.values()).sorted(iconNameComparator).map(i -> IconsBrowser.createIconButton(i, i.name())).collect(Collectors.toList());
        this.iconsBox.getChildren().addAll(list);
        this.iconsBox.prefWidthProperty().bind((ObservableValue)this.iconsScrollPane.widthProperty().subtract(20.0));
        this.numberOfIconsLabel.setText(list.size() + "");
    }

    private static Button createIconButton(AwesomeIcon icon, String text) {
        Tooltip tooltip = new Tooltip(String.format("%s: %s", icon.name(), icon.toUnicode()));
        Button b = AwesomeDude.createIconButton(icon, text, "2em", "0.8em", ContentDisplay.TOP);
        b.setTooltip(tooltip);
        b.setPrefWidth(180.0);
        b.setOnAction(t -> {
            Clipboard clipboard = Clipboard.getSystemClipboard();
            ClipboardContent content = new ClipboardContent();
            content.putString(icon.name());
            clipboard.setContent((Map)content);
        });
        return b;
    }
}

