/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.HashMultimap;
import com.inet.lib.less.LessExtend;
import com.inet.lib.less.LessExtendResult;
import com.inet.lib.less.SelectorTokenizer;
import com.inet.lib.less.SelectorUtils;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;

class LessExtendMap {
    private final HashMultimap<String, LessExtendResult> all;
    private final HashMultimap<String, String[]> exact;
    private final LinkedHashSet<String> selectorList = new LinkedHashSet();
    private final ArrayDeque<SelectorTokenizer> tokenizers = new ArrayDeque<SelectorTokenizer>(){

        @Override
        public SelectorTokenizer pollLast() {
            if (this.size() == 0) {
                return new SelectorTokenizer();
            }
            return (SelectorTokenizer)super.pollLast();
        }
    };

    LessExtendMap() {
        this.all = new HashMultimap();
        this.exact = new HashMultimap();
    }

    LessExtendMap(LessExtendMap parent) {
        this.all = new HashMultimap<String, LessExtendResult>(parent.all);
        this.exact = new HashMultimap<String, String[]>(parent.exact);
    }

    void add(LessExtend lessExtend, String[] mainSelector) {
        mainSelector = mainSelector == null || mainSelector[0].startsWith("@media") ? lessExtend.getSelectors() : SelectorUtils.merge(mainSelector, lessExtend.getSelectors());
        String extendingSelector = lessExtend.getExtendingSelector();
        if (lessExtend.isAll()) {
            String token;
            LessExtendResult extend = new LessExtendResult(mainSelector, extendingSelector);
            SelectorTokenizer tokenizer = this.tokenizers.pollLast().init(extendingSelector);
            while ((token = tokenizer.next()) != null) {
                this.all.add(token, extend);
            }
            this.tokenizers.addLast(tokenizer);
        } else {
            this.exact.add(extendingSelector, mainSelector);
        }
    }

    String[] concatenateExtends(String[] selectors, boolean isReference) {
        this.selectorList.clear();
        for (String selector : selectors) {
            this.concatenateExtendsRecursive(selector, isReference, selector);
        }
        if (isReference) {
            return this.selectorList.toArray(new String[this.selectorList.size()]);
        }
        if (this.selectorList.size() > 0) {
            for (String selector : selectors) {
                this.selectorList.remove(selector);
            }
            if (this.selectorList.size() > 0) {
                int off = selectors.length;
                selectors = Arrays.copyOf(selectors, off + this.selectorList.size());
                for (String str : this.selectorList) {
                    selectors[off++] = str;
                }
            }
        }
        return selectors;
    }

    private void concatenateExtendsRecursive(String selector, boolean isReference, String allSelector) {
        String token;
        List<String[]> list = this.exact.get(selector);
        if (list != null) {
            for (String[] lessExtend : list) {
                for (String sel : lessExtend) {
                    boolean needRecursion = this.selectorList.add(sel);
                    if (!needRecursion) continue;
                    this.concatenateExtendsRecursive(sel, isReference, sel);
                }
            }
        }
        SelectorTokenizer tokenizer = this.tokenizers.pollLast().init(allSelector);
        while ((token = tokenizer.next()) != null) {
            List<LessExtendResult> results = this.all.get(token);
            if (results == null) continue;
            for (LessExtendResult lessExtend : results) {
                String extendingSelector = lessExtend.getExtendingSelector();
                if (!selector.contains(extendingSelector)) continue;
                for (String replace : lessExtend.getSelectors()) {
                    String replacedSelector = selector.replace(extendingSelector, replace);
                    boolean needRecursion = this.selectorList.add(replacedSelector);
                    if (!needRecursion || replacedSelector.contains(extendingSelector)) continue;
                    this.concatenateExtendsRecursive(replacedSelector, isReference, replace);
                }
            }
        }
        this.tokenizers.addLast(tokenizer);
    }
}

