/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.CssFormatter;
import com.inet.lib.less.Expression;
import com.inet.lib.less.JavaScriptContext;
import com.inet.lib.less.LessObject;
import com.inet.lib.less.Operation;
import com.inet.lib.less.SelectorUtils;
import com.inet.lib.less.ValueExpression;
import java.util.Collection;
import java.util.Map;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;

public class JavaScriptExpression
extends Expression {
    private int type;
    private Object result;

    JavaScriptExpression(LessObject obj, String str) {
        super(obj, str);
    }

    @Override
    public void appendTo(CssFormatter formatter) {
        switch (this.getDataType(formatter)) {
            case 6: {
                formatter.append('\"').append(String.valueOf(this.result)).append('\"');
                return;
            }
            case 7: {
                this.listValue(formatter).appendTo(formatter);
                return;
            }
        }
        super.appendTo(formatter);
    }

    @Override
    int getDataType(CssFormatter formatter) {
        this.eval(formatter);
        return this.type;
    }

    @Override
    double doubleValue(CssFormatter formatter) {
        return ((Number)this.result).doubleValue();
    }

    @Override
    boolean booleanValue(CssFormatter formatter) {
        return (Boolean)this.result;
    }

    @Override
    String unit(CssFormatter formatter) {
        return "";
    }

    @Override
    public Operation listValue(CssFormatter formatter) {
        this.eval(formatter);
        if (this.type == 7) {
            Operation op = new Operation(this);
            for (Object obj : (Collection)this.result) {
                op.addOperand(new ValueExpression(this, obj));
            }
            return op;
        }
        return super.listValue(formatter);
    }

    private void eval(CssFormatter formatter) {
        if (this.type != 0) {
            return;
        }
        try {
            ScriptEngineManager factory = new ScriptEngineManager(this.getClass().getClassLoader());
            ScriptEngine engine = factory.getEngineByName("JavaScript");
            engine.setContext(new JavaScriptContext(formatter, this));
            String script = this.toString();
            script = SelectorUtils.replacePlaceHolder(formatter, script, this);
            script = script.substring(1, script.length() - 1);
            this.result = engine.eval(script);
            if (this.result instanceof Number) {
                this.type = 2;
            } else if (this.result instanceof Boolean) {
                this.type = 1;
            } else if (this.result instanceof Collection) {
                this.type = 7;
            } else if (this.result instanceof Map) {
                this.result = ((Map)this.result).values();
                this.type = 7;
            } else {
                this.type = 6;
            }
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
    }
}

