/*
 * Decompiled with CFR 0.152.
 */
package com.inet.lib.less;

import com.inet.lib.less.ColorUtils;
import com.inet.lib.less.CssFormatter;
import com.inet.lib.less.Formattable;
import com.inet.lib.less.FunctionExpression;
import com.inet.lib.less.LessObject;
import com.inet.lib.less.Operation;
import com.inet.lib.less.VariableExpression;

abstract class Expression
extends LessObject
implements Formattable {
    static final int UNKNOWN = 0;
    static final int BOOLEAN = 1;
    static final int NUMBER = 2;
    static final int PERCENT = 3;
    static final int RGBA = 4;
    static final int COLOR = 5;
    static final int STRING = 6;
    static final int LIST = 7;
    static final long ALPHA_1 = -281474976710656L;
    static final double WHITE = Double.longBitsToDouble(-1095233372416L);
    static final double BLACK = Double.longBitsToDouble(-281474976710656L);
    private String str;
    private boolean important;

    Expression(LessObject obj, String str) {
        super(obj);
        this.str = str;
    }

    @Override
    public final int getType() {
        return 3;
    }

    @Override
    public void appendTo(CssFormatter formatter) {
        switch (this.getDataType(formatter)) {
            case 1: {
                formatter.append(Boolean.toString(this.booleanValue(formatter)));
                return;
            }
            case 3: {
                double d = this.doubleValue(formatter);
                formatter.append(d);
                formatter.append('%');
                return;
            }
            case 2: {
                double d = this.doubleValue(formatter);
                formatter.appendValue(d, this.unit(formatter));
                return;
            }
            case 5: {
                formatter.appendColor(this.doubleValue(formatter), null);
                return;
            }
            case 4: {
                double color = this.doubleValue(formatter);
                if (color == 0.0 && Double.doubleToRawLongBits(color) == 0L) {
                    formatter.append("transparent");
                } else {
                    double alpha = ColorUtils.alpha(color);
                    if (alpha >= 1.0) {
                        formatter.appendColor(color, null);
                    } else {
                        formatter.append("rgba(");
                        formatter.append(ColorUtils.red(color)).append(',').space();
                        formatter.append(ColorUtils.green(color)).append(',').space();
                        formatter.append(ColorUtils.blue(color)).append(',').space();
                        formatter.append(alpha).append(')');
                    }
                }
                return;
            }
        }
        formatter.append(this.str);
    }

    abstract int getDataType(CssFormatter var1);

    abstract double doubleValue(CssFormatter var1);

    abstract boolean booleanValue(CssFormatter var1);

    String stringValue(CssFormatter formatter) {
        String str2;
        try {
            formatter.addOutput();
            this.appendTo(formatter);
        }
        catch (Exception ex) {
            throw this.createException(ex);
        }
        finally {
            String str2 = formatter.releaseOutput();
        }
        return str2;
    }

    boolean isImportant() {
        return this.important;
    }

    void setImportant() {
        this.important = true;
    }

    public Operation listValue(CssFormatter formatter) {
        Expression expr = this.unpack(formatter);
        if (expr == this) {
            throw this.createException("Exprestion is not a list: " + this);
        }
        return expr.listValue(formatter);
    }

    abstract String unit(CssFormatter var1);

    public String toString() {
        return this.str;
    }

    Expression unpack(CssFormatter formatter) {
        Expression unpack = this;
        while (true) {
            if (unpack.getClass() == FunctionExpression.class && ((FunctionExpression)unpack).toString().isEmpty()) {
                unpack = ((FunctionExpression)unpack).get(0);
                continue;
            }
            if (unpack.getClass() != VariableExpression.class) break;
            unpack = ((VariableExpression)unpack).getValue(formatter);
        }
        return unpack;
    }
}

