/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.services;

import de.codecentric.boot.admin.server.domain.values.InstanceId;
import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.logging.Level;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.Disposable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.retry.Retry;

public class IntervalCheck {
    private static final Logger log = LoggerFactory.getLogger(IntervalCheck.class);
    private final String name;
    private final Map<InstanceId, Instant> lastChecked = new ConcurrentHashMap<InstanceId, Instant>();
    private final Function<InstanceId, Mono<Void>> checkFn;
    private Duration interval;
    private Duration minRetention;
    @Nullable
    private Disposable subscription;

    public IntervalCheck(String name, Function<InstanceId, Mono<Void>> checkFn) {
        this(name, checkFn, Duration.ofSeconds(10L), Duration.ofSeconds(10L));
    }

    public IntervalCheck(String name, Function<InstanceId, Mono<Void>> checkFn, Duration interval, Duration minRetention) {
        this.name = name;
        this.checkFn = checkFn;
        this.interval = interval;
        this.minRetention = minRetention;
    }

    public void start() {
        Scheduler scheduler = Schedulers.newSingle((String)(this.name + "-check"));
        this.subscription = Flux.interval((Duration)this.interval).doOnSubscribe(s -> log.debug("Scheduled {}-check every {}", (Object)this.name, (Object)this.interval)).log(log.getName(), Level.FINEST, new SignalType[0]).subscribeOn(scheduler).concatMap(i -> this.checkAllInstances()).retryWhen((Function)Retry.any().retryMax(Long.MAX_VALUE).doOnRetry(ctx -> log.warn("Unexpected error in {}-check", (Object)this.name, (Object)ctx.exception()))).doFinally(s -> scheduler.dispose()).subscribe();
    }

    public void markAsChecked(InstanceId instanceId) {
        this.lastChecked.put(instanceId, Instant.now());
    }

    protected Mono<Void> checkAllInstances() {
        log.debug("check {} for all instances", (Object)this.name);
        Instant expiration = Instant.now().minus(this.minRetention);
        return Flux.fromIterable(this.lastChecked.entrySet()).filter(e -> ((Instant)e.getValue()).isBefore(expiration)).map(Map.Entry::getKey).flatMap(this.checkFn).then();
    }

    public void stop() {
        if (this.subscription != null) {
            this.subscription.dispose();
        }
    }

    public void setInterval(Duration interval) {
        this.interval = interval;
    }

    public void setMinRetention(Duration minRetention) {
        this.minRetention = minRetention;
    }
}

