/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web.client;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.web.client.HttpHeadersProvider;
import de.codecentric.boot.admin.server.web.client.InstanceExchangeFilterFunction;
import de.codecentric.boot.admin.server.web.client.InstanceExchangeFilterFunctions;
import de.codecentric.boot.admin.server.web.client.LegacyEndpointConverters;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.handler.timeout.ReadTimeoutHandler;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.springframework.boot.web.reactive.function.client.WebClientCustomizer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Mono;
import reactor.netty.ConnectionObserver;
import reactor.netty.http.client.HttpClient;

public class InstanceWebClient {
    private final WebClient webClient;

    private InstanceWebClient(WebClient webClient) {
        this.webClient = webClient;
    }

    public WebClient instance(Mono<Instance> instance) {
        return this.webClient.mutate().filters(filters -> filters.add(0, InstanceExchangeFilterFunctions.setInstance(instance))).build();
    }

    public WebClient instance(Instance instance) {
        return this.webClient.mutate().filters(filters -> filters.add(0, InstanceExchangeFilterFunctions.setInstance(instance))).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Duration connectTimeout = Duration.ofSeconds(2L);
        private Duration readTimeout = Duration.ofSeconds(5L);
        private WebClientCustomizer webClientCustomizer = builder -> {};
        private int defaultRetries = 0;
        private Map<String, Integer> retriesPerEndpoint = Collections.emptyMap();
        private HttpHeadersProvider httpHeadersProvider = instance -> HttpHeaders.EMPTY;
        private List<InstanceExchangeFilterFunction> filters = new ArrayList<InstanceExchangeFilterFunction>();
        private WebClient webClient = null;

        public Builder webClientCustomizer(WebClientCustomizer webClientCustomizer) {
            this.webClientCustomizer = webClientCustomizer;
            return this;
        }

        public Builder webClient(WebClient webClient) {
            this.webClient = webClient;
            return this;
        }

        public Builder readTimeout(Duration readTimeout) {
            this.readTimeout = readTimeout;
            return this;
        }

        public Builder connectTimeout(Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder defaultRetries(int defaultRetry) {
            this.defaultRetries = defaultRetry;
            return this;
        }

        public Builder retries(Map<String, Integer> retryPerEndpoint) {
            this.retriesPerEndpoint = retryPerEndpoint;
            return this;
        }

        public Builder httpHeadersProvider(HttpHeadersProvider httpHeadersProvider) {
            this.httpHeadersProvider = httpHeadersProvider;
            return this;
        }

        public Builder filter(InstanceExchangeFilterFunction filter) {
            this.filters.add(filter);
            return this;
        }

        public Builder filters(Consumer<List<InstanceExchangeFilterFunction>> filtersConsumer) {
            filtersConsumer.accept(this.filters);
            return this;
        }

        public InstanceWebClient build() {
            WebClient.Builder webClientBuilder = this.webClient == null ? Builder.createDefaultWebClient(this.connectTimeout, this.readTimeout) : this.webClient.mutate();
            webClientBuilder.filters(webClientFilters -> {
                webClientFilters.add(InstanceExchangeFilterFunctions.addHeaders(this.httpHeadersProvider));
                webClientFilters.add(InstanceExchangeFilterFunctions.rewriteEndpointUrl());
                webClientFilters.add(InstanceExchangeFilterFunctions.setDefaultAcceptHeader());
                webClientFilters.add(InstanceExchangeFilterFunctions.convertLegacyEndpoint(LegacyEndpointConverters.health()));
                webClientFilters.add(InstanceExchangeFilterFunctions.convertLegacyEndpoint(LegacyEndpointConverters.info()));
                webClientFilters.add(InstanceExchangeFilterFunctions.convertLegacyEndpoint(LegacyEndpointConverters.env()));
                webClientFilters.add(InstanceExchangeFilterFunctions.convertLegacyEndpoint(LegacyEndpointConverters.httptrace()));
                webClientFilters.add(InstanceExchangeFilterFunctions.convertLegacyEndpoint(LegacyEndpointConverters.threaddump()));
                webClientFilters.add(InstanceExchangeFilterFunctions.convertLegacyEndpoint(LegacyEndpointConverters.liquibase()));
                webClientFilters.add(InstanceExchangeFilterFunctions.convertLegacyEndpoint(LegacyEndpointConverters.flyway()));
                webClientFilters.add(InstanceExchangeFilterFunctions.retry(this.defaultRetries, this.retriesPerEndpoint));
                this.filters.forEach(filter -> webClientFilters.add(InstanceExchangeFilterFunctions.toExchangeFilterFunction(filter)));
            });
            this.webClientCustomizer.customize(webClientBuilder);
            return new InstanceWebClient(webClientBuilder.build());
        }

        private static WebClient.Builder createDefaultWebClient(Duration connectTimeout, Duration readTimeout) {
            HttpClient httpClient = HttpClient.create().compress(true).tcpConfiguration(tcp -> tcp.bootstrap(bootstrap -> (Bootstrap)bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)connectTimeout.toMillis()))).observe((connection, newState) -> {
                if (ConnectionObserver.State.CONNECTED.equals(newState)) {
                    connection.addHandlerLast((ChannelHandler)new ReadTimeoutHandler(readTimeout.toMillis(), TimeUnit.MILLISECONDS));
                }
            }));
            ReactorClientHttpConnector connector = new ReactorClientHttpConnector(httpClient);
            return WebClient.builder().clientConnector((ClientHttpConnector)connector);
        }
    }
}

