/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.services.endpoints;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.values.Endpoint;
import de.codecentric.boot.admin.server.domain.values.Endpoints;
import de.codecentric.boot.admin.server.domain.values.Registration;
import de.codecentric.boot.admin.server.services.endpoints.EndpointDetectionStrategy;
import de.codecentric.boot.admin.server.web.client.InstanceWebClient;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.http.MediaType;
import reactor.core.publisher.Mono;

public class QueryIndexEndpointStrategy
implements EndpointDetectionStrategy {
    private final InstanceWebClient instanceWebClient;
    private static final MediaType actuatorMediaType = MediaType.parseMediaType((String)"application/vnd.spring-boot.actuator.v2+json");

    public QueryIndexEndpointStrategy(InstanceWebClient instanceWebClient) {
        this.instanceWebClient = instanceWebClient;
    }

    @Override
    public Mono<Endpoints> detectEndpoints(Instance instance) {
        Registration registration = instance.getRegistration();
        if (Objects.equals(registration.getServiceUrl(), registration.getManagementUrl())) {
            return Mono.empty();
        }
        return this.instanceWebClient.instance(instance).get().uri(instance.getRegistration().getManagementUrl(), new Object[0]).exchange().flatMap(response -> {
            if (response.statusCode().is2xxSuccessful()) {
                if (response.headers().contentType().map(arg_0 -> ((MediaType)actuatorMediaType).isCompatibleWith(arg_0)).orElse(false).booleanValue()) {
                    return response.bodyToMono(Response.class);
                }
            }
            return response.bodyToMono(Void.class).then(Mono.empty());
        }).flatMap(this::convert);
    }

    private Mono<Endpoints> convert(Response response) {
        List<Endpoint> endpoints = response.get_links().entrySet().stream().filter(e -> !((String)e.getKey()).equals("self") && !((Response.EndpointRef)e.getValue()).isTemplated()).map(e -> Endpoint.of((String)e.getKey(), ((Response.EndpointRef)e.getValue()).getHref())).collect(Collectors.toList());
        if (endpoints.isEmpty()) {
            return Mono.empty();
        }
        return Mono.just((Object)Endpoints.of(endpoints));
    }

    static class Response {
        private Map<String, EndpointRef> _links;

        public Map<String, EndpointRef> get_links() {
            return this._links;
        }

        public void set_links(Map<String, EndpointRef> _links) {
            this._links = _links;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Response)) {
                return false;
            }
            Response other = (Response)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Map<String, EndpointRef> this$_links = this.get_links();
            Map<String, EndpointRef> other$_links = other.get_links();
            return !(this$_links == null ? other$_links != null : !((Object)this$_links).equals(other$_links));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Response;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Map<String, EndpointRef> $_links = this.get_links();
            result = result * 59 + ($_links == null ? 43 : ((Object)$_links).hashCode());
            return result;
        }

        public String toString() {
            return "QueryIndexEndpointStrategy.Response(_links=" + this.get_links() + ")";
        }

        static class EndpointRef {
            private String href;
            private boolean templated;

            public String getHref() {
                return this.href;
            }

            public boolean isTemplated() {
                return this.templated;
            }

            public void setHref(String href) {
                this.href = href;
            }

            public void setTemplated(boolean templated) {
                this.templated = templated;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof EndpointRef)) {
                    return false;
                }
                EndpointRef other = (EndpointRef)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$href = this.getHref();
                String other$href = other.getHref();
                if (this$href == null ? other$href != null : !this$href.equals(other$href)) {
                    return false;
                }
                return this.isTemplated() == other.isTemplated();
            }

            protected boolean canEqual(Object other) {
                return other instanceof EndpointRef;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $href = this.getHref();
                result = result * 59 + ($href == null ? 43 : $href.hashCode());
                result = result * 59 + (this.isTemplated() ? 79 : 97);
                return result;
            }

            public String toString() {
                return "QueryIndexEndpointStrategy.Response.EndpointRef(href=" + this.getHref() + ", templated=" + this.isTemplated() + ")";
            }
        }
    }
}

