/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.entities.Instance;
import de.codecentric.boot.admin.server.domain.entities.InstanceRepository;
import de.codecentric.boot.admin.server.domain.events.InstanceDeregisteredEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.domain.events.InstanceStatusChangedEvent;
import de.codecentric.boot.admin.server.domain.values.InstanceId;
import de.codecentric.boot.admin.server.notify.AbstractEventNotifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import reactor.core.publisher.Mono;

public abstract class AbstractStatusChangeNotifier
extends AbstractEventNotifier {
    private final Map<InstanceId, String> lastStatuses = new HashMap<InstanceId, String>();
    private String[] ignoreChanges = new String[]{"UNKNOWN:UP"};

    public AbstractStatusChangeNotifier(InstanceRepository repositpry) {
        super(repositpry);
    }

    @Override
    public Mono<Void> notify(InstanceEvent event) {
        return super.notify(event).then(Mono.fromRunnable(() -> this.updateLastStatus(event)));
    }

    @Override
    protected boolean shouldNotify(InstanceEvent event, Instance instance) {
        if (event instanceof InstanceStatusChangedEvent) {
            InstanceStatusChangedEvent statusChange = (InstanceStatusChangedEvent)event;
            String from = this.getLastStatus(event.getInstance());
            String to = statusChange.getStatusInfo().getStatus();
            return Arrays.binarySearch(this.ignoreChanges, from + ":" + to) < 0 && Arrays.binarySearch(this.ignoreChanges, "*:" + to) < 0 && Arrays.binarySearch(this.ignoreChanges, from + ":*") < 0;
        }
        return false;
    }

    protected final String getLastStatus(InstanceId instanceId) {
        return this.lastStatuses.getOrDefault(instanceId, "UNKNOWN");
    }

    protected void updateLastStatus(InstanceEvent event) {
        if (event instanceof InstanceDeregisteredEvent) {
            this.lastStatuses.remove(event.getInstance());
        }
        if (event instanceof InstanceStatusChangedEvent) {
            this.lastStatuses.put(event.getInstance(), ((InstanceStatusChangedEvent)event).getStatusInfo().getStatus());
        }
    }

    public void setIgnoreChanges(String[] ignoreChanges) {
        Object[] copy = Arrays.copyOf(ignoreChanges, ignoreChanges.length);
        Arrays.sort(copy);
        this.ignoreChanges = copy;
    }

    public String[] getIgnoreChanges() {
        return this.ignoreChanges;
    }
}

