/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.web.reactive;

import de.codecentric.boot.admin.server.services.InstanceRegistry;
import de.codecentric.boot.admin.server.web.AbstractInstancesProxyController;
import de.codecentric.boot.admin.server.web.AdminController;
import de.codecentric.boot.admin.server.web.client.InstanceWebClient;
import java.net.URI;
import java.time.Duration;
import java.util.Set;
import org.reactivestreams.Publisher;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.reactive.function.BodyExtractors;
import org.springframework.web.reactive.function.BodyInserters;
import org.springframework.web.util.UriComponentsBuilder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@AdminController
public class InstancesProxyController
extends AbstractInstancesProxyController {
    public InstancesProxyController(String adminContextPath, Set<String> ignoredHeaders, InstanceRegistry registry, InstanceWebClient instanceWebClient, Duration readTimeout) {
        super(adminContextPath, ignoredHeaders, registry, instanceWebClient, readTimeout);
    }

    @RequestMapping(path={"/instances/{instanceId}/actuator/**"}, method={RequestMethod.GET, RequestMethod.HEAD, RequestMethod.POST, RequestMethod.PUT, RequestMethod.PATCH, RequestMethod.DELETE, RequestMethod.OPTIONS})
    public Mono<Void> endpointProxy(@PathVariable(value="instanceId") String instanceId, ServerHttpRequest request, ServerHttpResponse response) {
        String endpointLocalPath = this.getEndpointLocalPath(request.getPath().pathWithinApplication().value());
        URI uri = UriComponentsBuilder.fromPath((String)endpointLocalPath).query(request.getURI().getRawQuery()).build(true).toUri();
        return super.forward(instanceId, uri, request.getMethod(), request.getHeaders(), () -> BodyInserters.fromDataBuffers((Publisher)request.getBody())).flatMap(clientResponse -> {
            response.setStatusCode(clientResponse.statusCode());
            response.getHeaders().addAll((MultiValueMap)this.filterHeaders(clientResponse.headers().asHttpHeaders()));
            return response.writeAndFlushWith((Publisher)((Flux)clientResponse.body(BodyExtractors.toDataBuffers())).window(1));
        });
    }
}

