/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.notify;

import de.codecentric.boot.admin.server.domain.events.InstanceEvent;
import de.codecentric.boot.admin.server.notify.Notifier;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class CompositeNotifier
implements Notifier {
    private final Iterable<Notifier> delegates;

    public CompositeNotifier(Iterable<Notifier> delegates) {
        Assert.notNull(delegates, (String)"'delegates' must not be null!");
        this.delegates = delegates;
    }

    @Override
    public Mono<Void> notify(InstanceEvent event) {
        return Flux.fromIterable(this.delegates).flatMap(d -> d.notify(event)).then();
    }
}

