/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class StatusInfo
implements Serializable {
    private static final long serialVersionUID = 2L;
    private final String status;
    private final long timestamp;
    private final Map<String, Serializable> details;

    protected StatusInfo(String status, long timestamp, Map<String, ? extends Serializable> details) {
        this.status = status.toUpperCase();
        this.timestamp = timestamp;
        this.details = details != null ? Collections.unmodifiableMap(new HashMap<String, Serializable>(details)) : Collections.emptyMap();
    }

    public static StatusInfo valueOf(String statusCode, Map<String, ? extends Serializable> details) {
        return new StatusInfo(statusCode, System.currentTimeMillis(), details);
    }

    public static StatusInfo valueOf(String statusCode) {
        return StatusInfo.valueOf(statusCode, null);
    }

    public static StatusInfo ofUnknown() {
        return StatusInfo.valueOf("UNKNOWN", null);
    }

    public static StatusInfo ofUp() {
        return StatusInfo.ofUp(null);
    }

    public static StatusInfo ofDown() {
        return StatusInfo.ofDown(null);
    }

    public static StatusInfo ofOffline() {
        return StatusInfo.ofOffline(null);
    }

    public static StatusInfo ofUp(Map<String, ? extends Serializable> details) {
        return StatusInfo.valueOf("UP", details);
    }

    public static StatusInfo ofDown(Map<String, ? extends Serializable> details) {
        return StatusInfo.valueOf("DOWN", details);
    }

    public static StatusInfo ofOffline(Map<String, ? extends Serializable> details) {
        return StatusInfo.valueOf("OFFLINE", details);
    }

    public String getStatus() {
        return this.status;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public Map<String, Serializable> getDetails() {
        return this.details;
    }

    @JsonIgnore
    public boolean isUp() {
        return "UP".equals(this.status);
    }

    @JsonIgnore
    public boolean isOffline() {
        return "OFFLINE".equals(this.status);
    }

    @JsonIgnore
    public boolean isDown() {
        return "DOWN".equals(this.status);
    }

    @JsonIgnore
    public boolean isUnknown() {
        return "UNKNOWN".equals(this.status);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatusInfo other = (StatusInfo)obj;
        return !(this.status == null ? other.status != null : !this.status.equals(other.status));
    }

    public String toString() {
        return "StatusInfo [status=" + this.status + ", timestamp=" + this.timestamp + "]";
    }
}

