/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.jackson;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import de.codecentric.boot.admin.model.Application;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;

public class ApplicationDeserializer
extends StdDeserializer<Application> {
    private static final long serialVersionUID = 1L;

    public ApplicationDeserializer() {
        super(Application.class);
    }

    public Application deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
        JsonNode node = (JsonNode)p.readValueAsTree();
        Application.Builder builder = Application.create(node.get("name").asText());
        if (node.has("url")) {
            String url = node.get("url").asText();
            builder.withHealthUrl(url.replaceFirst("/+$", "") + "/health").withManagementUrl(url);
        } else {
            if (node.has("healthUrl")) {
                builder.withHealthUrl(node.get("healthUrl").asText());
            }
            if (node.has("managementUrl")) {
                builder.withManagementUrl(node.get("managementUrl").asText());
            }
            if (node.has("serviceUrl")) {
                builder.withServiceUrl(node.get("serviceUrl").asText());
            }
        }
        if (node.has("metadata")) {
            Iterator it = node.get("metadata").fields();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                builder.addMetadata((String)entry.getKey(), ((JsonNode)entry.getValue()).asText());
            }
        }
        return builder.build();
    }
}

