/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.zuul.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.springframework.cloud.netflix.zuul.filters.RefreshableRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.cloud.netflix.zuul.filters.RouteLocator;
import org.springframework.util.Assert;

public class CompositeRouteLocator
implements RefreshableRouteLocator {
    private final Collection<? extends RouteLocator> routeLocators;

    public CompositeRouteLocator(Collection<? extends RouteLocator> routeLocators) {
        Assert.notNull(routeLocators);
        this.routeLocators = routeLocators;
    }

    public Collection<String> getIgnoredPaths() {
        HashSet<String> ignoredPaths = new HashSet<String>();
        for (RouteLocator routeLocator : this.routeLocators) {
            ignoredPaths.addAll(routeLocator.getIgnoredPaths());
        }
        return ignoredPaths;
    }

    public List<Route> getRoutes() {
        ArrayList<Route> route = new ArrayList<Route>();
        for (RouteLocator routeLocator : this.routeLocators) {
            route.addAll(routeLocator.getRoutes());
        }
        return route;
    }

    public Route getMatchingRoute(String path) {
        for (RouteLocator routeLocator : this.routeLocators) {
            Route route = routeLocator.getMatchingRoute(path);
            if (route == null) continue;
            return route;
        }
        return null;
    }

    public void refresh() {
        for (RouteLocator routeLocator : this.routeLocators) {
            if (!(routeLocator instanceof RefreshableRouteLocator)) continue;
            ((RefreshableRouteLocator)routeLocator).refresh();
        }
    }
}

