/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.zuul;

import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.registry.ApplicationRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.netflix.zuul.filters.RefreshableRouteLocator;
import org.springframework.cloud.netflix.zuul.filters.Route;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;

public class ApplicationRouteLocator
implements RefreshableRouteLocator {
    private static final Logger LOGGER = LoggerFactory.getLogger(ApplicationRouteLocator.class);
    private ApplicationRegistry registry;
    private PathMatcher pathMatcher = new AntPathMatcher();
    private AtomicReference<List<Route>> routes = new AtomicReference();
    private String prefix;
    private String servletPath;
    private String[] endpoints = new String[0];

    public ApplicationRouteLocator(String servletPath, ApplicationRegistry registry, String prefix) {
        this.servletPath = servletPath;
        this.registry = registry;
        this.prefix = prefix;
    }

    protected List<Route> locateRoutes() {
        Collection<Application> applications = this.registry.getApplications();
        ArrayList<Route> locateRoutes = new ArrayList<Route>(applications.size() * (this.endpoints.length + 1));
        for (Application application : applications) {
            this.addRoute(locateRoutes, application.getId(), "health", application.getHealthUrl());
            if (StringUtils.isEmpty((Object)application.getManagementUrl())) continue;
            for (String endpoint : this.endpoints) {
                this.addRoute(locateRoutes, application.getId(), endpoint, application.getManagementUrl() + "/" + endpoint);
            }
        }
        return locateRoutes;
    }

    private void addRoute(List<Route> locateRoutes, String applicationId, String endpoint, String targetUrl) {
        String routeId = applicationId + "-" + endpoint;
        Route route = new Route(routeId, "/**", targetUrl, this.prefix + applicationId + "/" + endpoint, Boolean.valueOf(false), null);
        locateRoutes.add(route);
    }

    public Route getMatchingRoute(String path) {
        LOGGER.debug("Finding route for path: {}", (Object)path);
        if (this.routes.get() == null) {
            this.routes.set(this.locateRoutes());
        }
        LOGGER.debug("servletPath= {}", (Object)this.servletPath);
        String adjustedPath = this.stripServletPath(path);
        for (Route route : this.routes.get()) {
            String pattern = route.getFullPath();
            LOGGER.debug("Matching pattern: {}", (Object)pattern);
            if (!this.pathMatcher.match(pattern, adjustedPath)) continue;
            LOGGER.debug("route matched= {}", (Object)route);
            return this.adjustPathRoute(route, adjustedPath);
        }
        return null;
    }

    private Route adjustPathRoute(Route route, String path) {
        String adjustedPath = path.startsWith(route.getPrefix()) ? path.substring(route.getPrefix().length()) : path;
        return new Route(route.getId(), adjustedPath, route.getLocation(), route.getPrefix(), route.getRetryable(), null);
    }

    public List<Route> getRoutes() {
        if (this.routes.get() == null) {
            this.routes.set(this.locateRoutes());
        }
        return new ArrayList<Route>((Collection)this.routes.get());
    }

    public void refresh() {
        this.routes.set(this.locateRoutes());
    }

    public Collection<String> getIgnoredPaths() {
        return Collections.emptyList();
    }

    public void setEndpoints(String[] proxyEndpoints) {
        for (String endpoint : proxyEndpoints) {
            Assert.hasText((String)endpoint, (String)"The proxyEndpoints must not contain null");
            Assert.isTrue((!endpoint.startsWith("/") ? 1 : 0) != 0, (String)"All proxyEndpoints must not start with '/'");
        }
        this.endpoints = (String[])proxyEndpoints.clone();
    }

    private String stripServletPath(String path) {
        String adjustedPath = path;
        if (StringUtils.hasText((String)this.servletPath) && !"/".equals(this.servletPath)) {
            adjustedPath = path.substring(this.servletPath.length());
        }
        LOGGER.debug("adjustedPath={}", (Object)path);
        return adjustedPath;
    }
}

