/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.notify;

import de.codecentric.boot.admin.event.ClientApplicationDeregisteredEvent;
import de.codecentric.boot.admin.event.ClientApplicationEvent;
import de.codecentric.boot.admin.event.ClientApplicationStatusChangedEvent;
import de.codecentric.boot.admin.notify.Notifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class RemindingNotifier
implements Notifier {
    private final ConcurrentHashMap<String, Reminder> reminders = new ConcurrentHashMap();
    private long reminderPeriod = TimeUnit.MINUTES.toMillis(10L);
    private String[] reminderStatuses = new String[]{"DOWN", "OFFLINE"};
    private final Notifier delegate;

    public RemindingNotifier(Notifier delegate) {
        this.delegate = delegate;
    }

    @Override
    public void notify(ClientApplicationEvent event) {
        this.delegate.notify(event);
        if (this.shouldEndReminder(event)) {
            this.reminders.remove(event.getApplication().getId());
        } else if (this.shouldStartReminder(event)) {
            this.reminders.putIfAbsent(event.getApplication().getId(), new Reminder(event));
        }
    }

    public void sendReminders() {
        long now = System.currentTimeMillis();
        for (Reminder reminder : new ArrayList<Reminder>(this.reminders.values())) {
            if (now - reminder.getLastNotification() <= this.reminderPeriod) continue;
            reminder.setLastNotification(now);
            this.delegate.notify(reminder.getEvent());
        }
    }

    protected boolean shouldStartReminder(ClientApplicationEvent event) {
        if (event instanceof ClientApplicationStatusChangedEvent) {
            return Arrays.binarySearch(this.reminderStatuses, event.getApplication().getStatusInfo().getStatus()) >= 0;
        }
        return false;
    }

    protected boolean shouldEndReminder(ClientApplicationEvent event) {
        if (event instanceof ClientApplicationDeregisteredEvent) {
            return true;
        }
        if (event instanceof ClientApplicationStatusChangedEvent) {
            return Arrays.binarySearch(this.reminderStatuses, event.getApplication().getStatusInfo().getStatus()) < 0;
        }
        return false;
    }

    public void setReminderPeriod(long reminderPeriod) {
        this.reminderPeriod = reminderPeriod;
    }

    public void setReminderStatuses(String[] reminderStatuses) {
        Object[] copy = Arrays.copyOf(reminderStatuses, reminderStatuses.length);
        Arrays.sort(copy);
        this.reminderStatuses = copy;
    }

    private static class Reminder {
        private final ClientApplicationEvent event;
        private long lastNotification;

        private Reminder(ClientApplicationEvent event) {
            this.event = event;
            this.lastNotification = event.getTimestamp();
        }

        public void setLastNotification(long lastNotification) {
            this.lastNotification = lastNotification;
        }

        public long getLastNotification() {
            return this.lastNotification;
        }

        public ClientApplicationEvent getEvent() {
            return this.event;
        }
    }
}

