/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.registry;

import de.codecentric.boot.admin.event.ClientApplicationStatusChangedEvent;
import de.codecentric.boot.admin.model.Application;
import de.codecentric.boot.admin.model.StatusInfo;
import de.codecentric.boot.admin.registry.store.ApplicationStore;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestTemplate;

public class StatusUpdater
implements ApplicationEventPublisherAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(StatusUpdater.class);
    private final ApplicationStore store;
    private final RestTemplate restTemplate;
    private ApplicationEventPublisher publisher;
    private long statusLifetime = 10000L;

    public StatusUpdater(RestTemplate restTemplate, ApplicationStore store) {
        this.restTemplate = restTemplate;
        this.store = store;
    }

    public void updateStatusForAllApplications() {
        long now = System.currentTimeMillis();
        for (Application application : this.store.findAll()) {
            if (now - this.statusLifetime <= application.getStatusInfo().getTimestamp()) continue;
            this.updateStatus(application);
        }
    }

    public void updateStatus(Application application) {
        StatusInfo oldStatus = application.getStatusInfo();
        StatusInfo newStatus = this.queryStatus(application);
        Application newState = Application.create((Application)application).withStatusInfo(newStatus).build();
        this.store.save(newState);
        if (!newStatus.equals((Object)oldStatus)) {
            this.publisher.publishEvent((Object)new ClientApplicationStatusChangedEvent(newState, oldStatus, newStatus));
        }
    }

    private StatusInfo queryStatus(Application application) {
        LOGGER.trace("Updating status for {}", (Object)application);
        try {
            ResponseEntity response = this.restTemplate.getForEntity(application.getHealthUrl(), Map.class, new Object[0]);
            LOGGER.debug("/health for {} responded with {}", (Object)application, (Object)response);
            if (response.hasBody() && ((Map)response.getBody()).get("status") instanceof String) {
                return StatusInfo.valueOf((String)((String)((Map)response.getBody()).get("status")));
            }
            if (response.getStatusCode().is2xxSuccessful()) {
                return StatusInfo.ofUp();
            }
            return StatusInfo.ofDown();
        }
        catch (Exception ex) {
            if ("OFFLINE".equals(application.getStatusInfo().getStatus())) {
                LOGGER.debug("Couldn't retrieve status for {}", (Object)application, (Object)ex);
            } else {
                LOGGER.warn("Couldn't retrieve status for {}", (Object)application, (Object)ex);
            }
            return StatusInfo.ofOffline();
        }
    }

    public void setStatusLifetime(long statusLifetime) {
        this.statusLifetime = statusLifetime;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher publisher) {
        this.publisher = publisher;
    }
}

