/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.ui.web;

import com.fasterxml.jackson.annotation.JsonInclude;
import de.codecentric.boot.admin.server.ui.extensions.UiExtension;
import de.codecentric.boot.admin.server.ui.extensions.UiExtensions;
import de.codecentric.boot.admin.server.web.AdminController;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.springframework.boot.context.properties.ConstructorBinding;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.util.UriComponents;
import org.springframework.web.util.UriComponentsBuilder;

@AdminController
public class UiController {
    private final String publicUrl;
    private final UiExtensions uiExtensions;
    private final Settings uiSettings;

    public UiController(String publicUrl, UiExtensions uiExtensions, Settings uiSettings) {
        this.publicUrl = publicUrl;
        this.uiExtensions = uiExtensions;
        this.uiSettings = uiSettings;
    }

    @ModelAttribute(value="baseUrl", binding=false)
    public String getBaseUrl(UriComponentsBuilder uriBuilder) {
        UriComponents publicComponents = UriComponentsBuilder.fromUriString((String)this.publicUrl).build();
        if (publicComponents.getScheme() != null) {
            uriBuilder.scheme(publicComponents.getScheme());
        }
        if (publicComponents.getHost() != null) {
            uriBuilder.host(publicComponents.getHost());
        }
        if (publicComponents.getPort() != -1) {
            uriBuilder.port(publicComponents.getPort());
        }
        if (publicComponents.getPath() != null) {
            uriBuilder.path(publicComponents.getPath());
        }
        return uriBuilder.path("/").toUriString();
    }

    @ModelAttribute(value="uiSettings", binding=false)
    public Settings getUiSettings() {
        return this.uiSettings;
    }

    @ModelAttribute(value="cssExtensions", binding=false)
    public List<UiExtension> getCssExtensions() {
        return this.uiExtensions.getCssExtensions();
    }

    @ModelAttribute(value="jsExtensions", binding=false)
    public List<UiExtension> getJsExtensions() {
        return this.uiExtensions.getJsExtensions();
    }

    @ModelAttribute(value="user", binding=false)
    public Map<String, Object> getUser(@Nullable Principal principal) {
        if (principal != null) {
            return Collections.singletonMap("name", principal.getName());
        }
        return Collections.emptyMap();
    }

    @GetMapping(path={"/"}, produces={"text/html"})
    public String index() {
        return "index";
    }

    @GetMapping(path={"/sba-settings.js"}, produces={"application/javascript"})
    public String sbaSettings() {
        return "sba-settings.js";
    }

    @GetMapping(path={"/login"}, produces={"text/html"})
    public String login() {
        return "login";
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    @ConstructorBinding
    public static class ExternalView {
        private final String label;
        private final String url;
        private final Integer order;
        private final boolean iframe;

        public ExternalView(String label, String url, Integer order, boolean iframe) {
            Assert.hasText((String)label, (String)"'label' must not be empty");
            Assert.hasText((String)url, (String)"'url' must not be empty");
            this.label = label;
            this.url = url;
            this.order = order;
            this.iframe = iframe;
        }

        public String getLabel() {
            return this.label;
        }

        public String getUrl() {
            return this.url;
        }

        public Integer getOrder() {
            return this.order;
        }

        public boolean isIframe() {
            return this.iframe;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExternalView)) {
                return false;
            }
            ExternalView other = (ExternalView)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$label = this.getLabel();
            String other$label = other.getLabel();
            if (this$label == null ? other$label != null : !this$label.equals(other$label)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            Integer this$order = this.getOrder();
            Integer other$order = other.getOrder();
            if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
                return false;
            }
            return this.isIframe() == other.isIframe();
        }

        protected boolean canEqual(Object other) {
            return other instanceof ExternalView;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $label = this.getLabel();
            result = result * 59 + ($label == null ? 43 : $label.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            Integer $order = this.getOrder();
            result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
            result = result * 59 + (this.isIframe() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "UiController.ExternalView(label=" + this.getLabel() + ", url=" + this.getUrl() + ", order=" + this.getOrder() + ", iframe=" + this.isIframe() + ")";
        }
    }

    public static class Settings {
        private final String title;
        private final String brand;
        private final String loginIcon;
        private final String favicon;
        private final String faviconDanger;
        private final boolean notificationFilterEnabled;
        private final boolean rememberMeEnabled;
        private final List<String> availableLanguages;
        private final List<String> routes;
        private final List<ExternalView> externalViews;

        Settings(String title, String brand, String loginIcon, String favicon, String faviconDanger, boolean notificationFilterEnabled, boolean rememberMeEnabled, List<String> availableLanguages, List<String> routes, List<ExternalView> externalViews) {
            this.title = title;
            this.brand = brand;
            this.loginIcon = loginIcon;
            this.favicon = favicon;
            this.faviconDanger = faviconDanger;
            this.notificationFilterEnabled = notificationFilterEnabled;
            this.rememberMeEnabled = rememberMeEnabled;
            this.availableLanguages = availableLanguages;
            this.routes = routes;
            this.externalViews = externalViews;
        }

        public static SettingsBuilder builder() {
            return new SettingsBuilder();
        }

        public String getTitle() {
            return this.title;
        }

        public String getBrand() {
            return this.brand;
        }

        public String getLoginIcon() {
            return this.loginIcon;
        }

        public String getFavicon() {
            return this.favicon;
        }

        public String getFaviconDanger() {
            return this.faviconDanger;
        }

        public boolean isNotificationFilterEnabled() {
            return this.notificationFilterEnabled;
        }

        public boolean isRememberMeEnabled() {
            return this.rememberMeEnabled;
        }

        public List<String> getAvailableLanguages() {
            return this.availableLanguages;
        }

        public List<String> getRoutes() {
            return this.routes;
        }

        public List<ExternalView> getExternalViews() {
            return this.externalViews;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Settings)) {
                return false;
            }
            Settings other = (Settings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$title = this.getTitle();
            String other$title = other.getTitle();
            if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
                return false;
            }
            String this$brand = this.getBrand();
            String other$brand = other.getBrand();
            if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
                return false;
            }
            String this$loginIcon = this.getLoginIcon();
            String other$loginIcon = other.getLoginIcon();
            if (this$loginIcon == null ? other$loginIcon != null : !this$loginIcon.equals(other$loginIcon)) {
                return false;
            }
            String this$favicon = this.getFavicon();
            String other$favicon = other.getFavicon();
            if (this$favicon == null ? other$favicon != null : !this$favicon.equals(other$favicon)) {
                return false;
            }
            String this$faviconDanger = this.getFaviconDanger();
            String other$faviconDanger = other.getFaviconDanger();
            if (this$faviconDanger == null ? other$faviconDanger != null : !this$faviconDanger.equals(other$faviconDanger)) {
                return false;
            }
            if (this.isNotificationFilterEnabled() != other.isNotificationFilterEnabled()) {
                return false;
            }
            if (this.isRememberMeEnabled() != other.isRememberMeEnabled()) {
                return false;
            }
            List<String> this$availableLanguages = this.getAvailableLanguages();
            List<String> other$availableLanguages = other.getAvailableLanguages();
            if (this$availableLanguages == null ? other$availableLanguages != null : !((Object)this$availableLanguages).equals(other$availableLanguages)) {
                return false;
            }
            List<String> this$routes = this.getRoutes();
            List<String> other$routes = other.getRoutes();
            if (this$routes == null ? other$routes != null : !((Object)this$routes).equals(other$routes)) {
                return false;
            }
            List<ExternalView> this$externalViews = this.getExternalViews();
            List<ExternalView> other$externalViews = other.getExternalViews();
            return !(this$externalViews == null ? other$externalViews != null : !((Object)this$externalViews).equals(other$externalViews));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Settings;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $title = this.getTitle();
            result = result * 59 + ($title == null ? 43 : $title.hashCode());
            String $brand = this.getBrand();
            result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
            String $loginIcon = this.getLoginIcon();
            result = result * 59 + ($loginIcon == null ? 43 : $loginIcon.hashCode());
            String $favicon = this.getFavicon();
            result = result * 59 + ($favicon == null ? 43 : $favicon.hashCode());
            String $faviconDanger = this.getFaviconDanger();
            result = result * 59 + ($faviconDanger == null ? 43 : $faviconDanger.hashCode());
            result = result * 59 + (this.isNotificationFilterEnabled() ? 79 : 97);
            result = result * 59 + (this.isRememberMeEnabled() ? 79 : 97);
            List<String> $availableLanguages = this.getAvailableLanguages();
            result = result * 59 + ($availableLanguages == null ? 43 : ((Object)$availableLanguages).hashCode());
            List<String> $routes = this.getRoutes();
            result = result * 59 + ($routes == null ? 43 : ((Object)$routes).hashCode());
            List<ExternalView> $externalViews = this.getExternalViews();
            result = result * 59 + ($externalViews == null ? 43 : ((Object)$externalViews).hashCode());
            return result;
        }

        public String toString() {
            return "UiController.Settings(title=" + this.getTitle() + ", brand=" + this.getBrand() + ", loginIcon=" + this.getLoginIcon() + ", favicon=" + this.getFavicon() + ", faviconDanger=" + this.getFaviconDanger() + ", notificationFilterEnabled=" + this.isNotificationFilterEnabled() + ", rememberMeEnabled=" + this.isRememberMeEnabled() + ", availableLanguages=" + this.getAvailableLanguages() + ", routes=" + this.getRoutes() + ", externalViews=" + this.getExternalViews() + ")";
        }

        public static class SettingsBuilder {
            private String title;
            private String brand;
            private String loginIcon;
            private String favicon;
            private String faviconDanger;
            private boolean notificationFilterEnabled;
            private boolean rememberMeEnabled;
            private List<String> availableLanguages;
            private List<String> routes;
            private List<ExternalView> externalViews;

            SettingsBuilder() {
            }

            public SettingsBuilder title(String title) {
                this.title = title;
                return this;
            }

            public SettingsBuilder brand(String brand) {
                this.brand = brand;
                return this;
            }

            public SettingsBuilder loginIcon(String loginIcon) {
                this.loginIcon = loginIcon;
                return this;
            }

            public SettingsBuilder favicon(String favicon) {
                this.favicon = favicon;
                return this;
            }

            public SettingsBuilder faviconDanger(String faviconDanger) {
                this.faviconDanger = faviconDanger;
                return this;
            }

            public SettingsBuilder notificationFilterEnabled(boolean notificationFilterEnabled) {
                this.notificationFilterEnabled = notificationFilterEnabled;
                return this;
            }

            public SettingsBuilder rememberMeEnabled(boolean rememberMeEnabled) {
                this.rememberMeEnabled = rememberMeEnabled;
                return this;
            }

            public SettingsBuilder availableLanguages(List<String> availableLanguages) {
                this.availableLanguages = availableLanguages;
                return this;
            }

            public SettingsBuilder routes(List<String> routes) {
                this.routes = routes;
                return this;
            }

            public SettingsBuilder externalViews(List<ExternalView> externalViews) {
                this.externalViews = externalViews;
                return this;
            }

            public Settings build() {
                return new Settings(this.title, this.brand, this.loginIcon, this.favicon, this.faviconDanger, this.notificationFilterEnabled, this.rememberMeEnabled, this.availableLanguages, this.routes, this.externalViews);
            }

            public String toString() {
                return "UiController.Settings.SettingsBuilder(title=" + this.title + ", brand=" + this.brand + ", loginIcon=" + this.loginIcon + ", favicon=" + this.favicon + ", faviconDanger=" + this.faviconDanger + ", notificationFilterEnabled=" + this.notificationFilterEnabled + ", rememberMeEnabled=" + this.rememberMeEnabled + ", availableLanguages=" + this.availableLanguages + ", routes=" + this.routes + ", externalViews=" + this.externalViews + ")";
            }
        }
    }
}

