/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.client.registration;

import de.codecentric.boot.admin.client.registration.Application;
import de.codecentric.boot.admin.client.registration.RegistrationClient;
import java.time.Duration;
import java.util.Map;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.MediaType;
import org.springframework.web.reactive.function.client.WebClient;

public class ReactiveRegistrationClient
implements RegistrationClient {
    private static final ParameterizedTypeReference<Map<String, Object>> RESPONSE_TYPE = new ParameterizedTypeReference<Map<String, Object>>(){};
    private final WebClient webclient;
    private final Duration timeout;

    public ReactiveRegistrationClient(WebClient webclient, Duration timeout) {
        this.webclient = webclient;
        this.timeout = timeout;
    }

    @Override
    public String register(String adminUrl, Application application) {
        Map response = (Map)((WebClient.RequestBodySpec)((WebClient.RequestBodySpec)this.webclient.post().uri(adminUrl, new Object[0])).accept(new MediaType[]{MediaType.APPLICATION_JSON})).contentType(MediaType.APPLICATION_JSON).syncBody((Object)application).retrieve().bodyToMono(RESPONSE_TYPE).timeout(this.timeout).block();
        return response.get("id").toString();
    }

    @Override
    public void deregister(String adminUrl, String id) {
        this.webclient.delete().uri(adminUrl + '/' + id, new Object[0]).retrieve().bodyToMono(Void.class).timeout(this.timeout).block();
    }
}

