/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.spring.boot.chaos.monkey.configuration;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultException;
import de.codecentric.spring.boot.chaos.monkey.configuration.AssaultExceptionConstraint;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="chaos.monkey.assaults")
@Validated
public class AssaultProperties {
    @Value(value="${level : 5}")
    @Min(value=1L)
    @Max(value=10000L)
    private @Min(value=1L) @Max(value=10000L) int level;
    @Value(value="${latencyRangeStart : 1000}")
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=1L) @Max(value=0x7FFFFFFFL) int latencyRangeStart;
    @Value(value="${latencyRangeEnd : 3000}")
    @Min(value=1L)
    @Max(value=0x7FFFFFFFL)
    private @Min(value=1L) @Max(value=0x7FFFFFFFL) int latencyRangeEnd;
    @Value(value="${latencyActive : true}")
    private boolean latencyActive;
    @Value(value="${exceptionsActive : false}")
    private boolean exceptionsActive;
    @AssaultExceptionConstraint
    private AssaultException exception;
    @Value(value="${killApplicationActive : false}")
    private boolean killApplicationActive;
    @Value(value="${watchedCustomServices:#{null}}")
    private List<String> watchedCustomServices;

    public AssaultException getException() {
        return this.exception == null ? new AssaultException() : this.exception;
    }

    public void setException(AssaultException exception) {
        this.exception = exception;
    }

    @JsonIgnore
    public int getTroubleRandom() {
        return ThreadLocalRandom.current().nextInt(1, this.getLevel() + 1);
    }

    @JsonIgnore
    public int chooseAssault(int amount) {
        return ThreadLocalRandom.current().nextInt(0, amount);
    }

    @JsonIgnore
    public boolean isWatchedCustomServicesActive() {
        return this.watchedCustomServices != null && !this.watchedCustomServices.isEmpty();
    }

    public int getLevel() {
        return this.level;
    }

    public int getLatencyRangeStart() {
        return this.latencyRangeStart;
    }

    public int getLatencyRangeEnd() {
        return this.latencyRangeEnd;
    }

    public boolean isLatencyActive() {
        return this.latencyActive;
    }

    public boolean isExceptionsActive() {
        return this.exceptionsActive;
    }

    public boolean isKillApplicationActive() {
        return this.killApplicationActive;
    }

    public List<String> getWatchedCustomServices() {
        return this.watchedCustomServices;
    }

    public void setLevel(int level) {
        this.level = level;
    }

    public void setLatencyRangeStart(int latencyRangeStart) {
        this.latencyRangeStart = latencyRangeStart;
    }

    public void setLatencyRangeEnd(int latencyRangeEnd) {
        this.latencyRangeEnd = latencyRangeEnd;
    }

    public void setLatencyActive(boolean latencyActive) {
        this.latencyActive = latencyActive;
    }

    public void setExceptionsActive(boolean exceptionsActive) {
        this.exceptionsActive = exceptionsActive;
    }

    public void setKillApplicationActive(boolean killApplicationActive) {
        this.killApplicationActive = killApplicationActive;
    }

    public void setWatchedCustomServices(List<String> watchedCustomServices) {
        this.watchedCustomServices = watchedCustomServices;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AssaultProperties)) {
            return false;
        }
        AssaultProperties other = (AssaultProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getLevel() != other.getLevel()) {
            return false;
        }
        if (this.getLatencyRangeStart() != other.getLatencyRangeStart()) {
            return false;
        }
        if (this.getLatencyRangeEnd() != other.getLatencyRangeEnd()) {
            return false;
        }
        if (this.isLatencyActive() != other.isLatencyActive()) {
            return false;
        }
        if (this.isExceptionsActive() != other.isExceptionsActive()) {
            return false;
        }
        AssaultException this$exception = this.getException();
        AssaultException other$exception = other.getException();
        if (this$exception == null ? other$exception != null : !((Object)this$exception).equals(other$exception)) {
            return false;
        }
        if (this.isKillApplicationActive() != other.isKillApplicationActive()) {
            return false;
        }
        List<String> this$watchedCustomServices = this.getWatchedCustomServices();
        List<String> other$watchedCustomServices = other.getWatchedCustomServices();
        return !(this$watchedCustomServices == null ? other$watchedCustomServices != null : !((Object)this$watchedCustomServices).equals(other$watchedCustomServices));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AssaultProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getLevel();
        result = result * 59 + this.getLatencyRangeStart();
        result = result * 59 + this.getLatencyRangeEnd();
        result = result * 59 + (this.isLatencyActive() ? 79 : 97);
        result = result * 59 + (this.isExceptionsActive() ? 79 : 97);
        AssaultException $exception = this.getException();
        result = result * 59 + ($exception == null ? 43 : ((Object)$exception).hashCode());
        result = result * 59 + (this.isKillApplicationActive() ? 79 : 97);
        List<String> $watchedCustomServices = this.getWatchedCustomServices();
        result = result * 59 + ($watchedCustomServices == null ? 43 : ((Object)$watchedCustomServices).hashCode());
        return result;
    }

    public String toString() {
        return "AssaultProperties(level=" + this.getLevel() + ", latencyRangeStart=" + this.getLatencyRangeStart() + ", latencyRangeEnd=" + this.getLatencyRangeEnd() + ", latencyActive=" + this.isLatencyActive() + ", exceptionsActive=" + this.isExceptionsActive() + ", exception=" + this.getException() + ", killApplicationActive=" + this.isKillApplicationActive() + ", watchedCustomServices=" + this.getWatchedCustomServices() + ")";
    }
}

