/*
 * Decompiled with CFR 0.152.
 */
package de.cketti.changelog.dialog;

import de.cketti.changelog.ReleaseItem;
import java.util.List;

class HtmlFormatter {
    private final String versionFormat;
    private final String css;

    public HtmlFormatter(String versionFormat, String css) {
        this.versionFormat = versionFormat;
        this.css = css;
    }

    public String createHtmlChangeLog(List<ReleaseItem> changelog) {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><head><style type=\"text/css\">");
        sb.append(this.css);
        sb.append("</style></head><body>");
        for (ReleaseItem release : changelog) {
            sb.append("<h1>");
            sb.append(String.format(this.versionFormat, release.versionName));
            sb.append("</h1><ul>");
            for (String change : release.changes) {
                sb.append("<li>");
                sb.append(change);
                sb.append("</li>");
            }
            sb.append("</ul>");
        }
        sb.append("</body></html>");
        return sb.toString();
    }
}

