/*
 * Decompiled with CFR 0.152.
 */
package de.cketti.changelog.dialog;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.view.View;
import android.webkit.WebView;
import de.cketti.changelog.ChangeLog;
import de.cketti.changelog.dialog.HtmlFormatter;
import de.cketti.changelog.dialog.R;
import java.util.List;

public final class DialogChangeLog {
    public static final String DEFAULT_CSS = "h1 { margin-left: 0px; font-size: 1.2em; }\nli { margin-left: 0px; }\nul { padding-left: 2em; }";
    private final Context context;
    private final ChangeLog changeLog;
    private final HtmlFormatter formatter;

    public static DialogChangeLog newInstance(Context context) {
        return DialogChangeLog.newInstance(context, DEFAULT_CSS);
    }

    public static DialogChangeLog newInstance(Context context, String css) {
        ChangeLog changeLog = ChangeLog.newInstance((Context)context);
        String versionFormat = context.getResources().getString(R.string.changelog_version_format);
        HtmlFormatter formatter = new HtmlFormatter(versionFormat, css);
        return new DialogChangeLog(context, changeLog, formatter);
    }

    private DialogChangeLog(Context context, ChangeLog changeLog, HtmlFormatter formatter) {
        this.context = context;
        this.changeLog = changeLog;
        this.formatter = formatter;
    }

    public ChangeLog getChangeLog() {
        return this.changeLog;
    }

    public AlertDialog getLogDialog() {
        return this.getDialog(this.changeLog.isFirstRunEver());
    }

    public AlertDialog getFullLogDialog() {
        return this.getDialog(true);
    }

    public boolean isFirstRun() {
        return this.changeLog.isFirstRun();
    }

    private AlertDialog getDialog(boolean full) {
        WebView webView = new WebView(this.context);
        webView.loadDataWithBaseURL(null, this.getChangeLogHtml(full), "text/html", "UTF-8", null);
        AlertDialog.Builder builder = new AlertDialog.Builder(this.context);
        builder.setTitle(full ? R.string.changelog_full_title : R.string.changelog_title).setView((View)webView).setCancelable(false).setPositiveButton(R.string.changelog_ok_button, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                DialogChangeLog.this.changeLog.writeCurrentVersion();
            }
        });
        if (!full) {
            builder.setNegativeButton(R.string.changelog_show_full, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int id) {
                    DialogChangeLog.this.getFullLogDialog().show();
                }
            });
        }
        return builder.create();
    }

    private String getChangeLogHtml(boolean full) {
        List changelog = full ? this.changeLog.getChangeLog() : this.changeLog.getRecentChanges();
        return this.formatter.createHtmlChangeLog(changelog);
    }
}

