/*
 * Decompiled with CFR 0.152.
 */
package de.bechte.junit.runners.validation;

import de.bechte.junit.runners.validation.TestClassValidator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.List;
import org.junit.runners.model.TestClass;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ConstructorValidator implements TestClassValidator
{
    VALID_CONSTRUCTOR;


    @Override
    public void validate(TestClass testClass, List<Throwable> errors) {
        if (!this.isAllowed(testClass.getJavaClass())) {
            return;
        }
        this.validateOnlyOneConstructor(testClass, errors);
        this.validateConstructorArgumentCount(testClass, errors);
    }

    private boolean isAllowed(Class<?> testClass) {
        return !Modifier.isStatic(testClass.getModifiers());
    }

    private void validateOnlyOneConstructor(TestClass testClass, List<Throwable> errors) {
        if (testClass.getJavaClass().getConstructors().length != 1) {
            errors.add(new Exception("Test class should have exactly one public constructor"));
        }
    }

    private void validateConstructorArgumentCount(TestClass testClass, List<Throwable> errors) {
        if (testClass.getJavaClass().isMemberClass()) {
            this.validateMemberClassConstructorArgumentCount(testClass, errors);
        } else {
            this.validateTopLevelClassConstructorArgumentCount(testClass, errors);
        }
    }

    private void validateMemberClassConstructorArgumentCount(TestClass testClass, List<Throwable> errors) {
        Constructor<?>[] constructors = testClass.getJavaClass().getConstructors();
        if (constructors.length == 1) {
            Class<?> enclosingClass = testClass.getJavaClass().getEnclosingClass();
            Class<?>[] parameterTypes = constructors[0].getParameterTypes();
            if (parameterTypes.length != 1 || !parameterTypes[0].isAssignableFrom(enclosingClass)) {
                errors.add(new Exception("Test class within a hierarchical context should have exactly one public one-argument constructor"));
            }
        }
    }

    private void validateTopLevelClassConstructorArgumentCount(TestClass testClass, List<Throwable> errors) {
        Class<?>[] parameterTypes;
        Constructor<?>[] constructors = testClass.getJavaClass().getConstructors();
        if (constructors.length == 1 && (parameterTypes = constructors[0].getParameterTypes()).length != 0) {
            errors.add(new Exception("Test class should have exactly one public zero-argument constructor"));
        }
    }
}

