/*
 * Decompiled with CFR 0.152.
 */
package de.bechte.junit.runners.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.Stack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ReflectionUtil {
    private ReflectionUtil() {
    }

    public static Object getEnclosingInstance(Object target) throws IllegalAccessException {
        if (target == null) {
            throw new IllegalArgumentException("Target must not be null!");
        }
        Class<?> targetClass = target.getClass();
        if (Modifier.isStatic(targetClass.getModifiers()) || !targetClass.isMemberClass()) {
            return null;
        }
        Class<?> enclosingClass = targetClass.getEnclosingClass();
        for (Field field : targetClass.getDeclaredFields()) {
            if (!field.getType().equals(enclosingClass)) continue;
            field.setAccessible(true);
            return field.get(target);
        }
        throw new IllegalStateException("Member instance has no field containing the enclosing instance!");
    }

    public static Stack<Class<?>> getClassHierarchy(Class<?> clazz) {
        Stack classHierarchy = new Stack();
        Class<?> c = clazz;
        while (c != null) {
            classHierarchy.push(c);
            c = Modifier.isStatic(c.getModifiers()) ? null : c.getEnclosingClass();
        }
        return classHierarchy;
    }

    public static Object createDeepInstance(Stack<Class<?>> classHierarchy) throws Throwable {
        if (classHierarchy == null || classHierarchy.isEmpty()) {
            throw new IllegalArgumentException("Stack must not be null or empty!");
        }
        try {
            Class<?> outerClass = classHierarchy.pop();
            Object test = outerClass.newInstance();
            while (!classHierarchy.empty()) {
                Class<?> innerClass = classHierarchy.pop();
                Constructor<?> innerConstructor = innerClass.getConstructor(outerClass);
                test = innerConstructor.newInstance(test);
                outerClass = innerClass;
            }
            return test;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
    }
}

