/*
 * Decompiled with CFR 0.152.
 */
package de.bechte.junit.runners.context.statements.builder;

import de.bechte.junit.runners.context.statements.builder.MethodStatementBuilder;
import de.bechte.junit.runners.model.TestClassPool;
import de.bechte.junit.runners.util.ReflectionUtil;
import java.util.LinkedList;
import org.junit.Rule;
import org.junit.internal.runners.statements.Fail;
import org.junit.rules.MethodRule;
import org.junit.rules.RunRules;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class HierarchicalRunRulesStatementBuilder
implements MethodStatementBuilder {
    public Statement createStatement(TestClass testClass, FrameworkMethod method, Object target, Statement next, Description description, RunNotifier notifier) {
        try {
            LinkedList testRules = new LinkedList();
            LinkedList methodRules = new LinkedList();
            Object instance = target;
            while (instance != null) {
                TestClass instanceTestClass = TestClassPool.forClass(instance.getClass());
                testRules.addAll(instanceTestClass.getAnnotatedMethodValues(instance, Rule.class, TestRule.class));
                testRules.addAll(instanceTestClass.getAnnotatedFieldValues(instance, Rule.class, TestRule.class));
                methodRules.addAll(instanceTestClass.getAnnotatedFieldValues(instance, Rule.class, MethodRule.class));
                instance = ReflectionUtil.getEnclosingInstance(instance);
            }
            Statement statement = next;
            for (MethodRule methodRule : methodRules) {
                if (testRules.contains(methodRule)) continue;
                statement = methodRule.apply(statement, method, target);
            }
            if (!testRules.isEmpty()) {
                statement = new RunRules(statement, testRules, description);
            }
            return statement;
        }
        catch (IllegalAccessException e) {
            return new Fail((Throwable)e);
        }
    }
}

