/*
 * Decompiled with CFR 0.152.
 */
package de.adorsys.oauth.server;

import com.nimbusds.jose.util.Base64;
import com.nimbusds.jwt.JWTClaimsSet;
import de.adorsys.oauth.server.EncryptedTokenSerializer;
import de.adorsys.oauth.server.LoginSessionToken;
import de.adorsys.oauth.server.OAuthException;
import java.security.Principal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jboss.security.SimpleGroup;
import org.jboss.security.SimplePrincipal;

public class RememberMeTokenUtil {
    private static final String SECRET_KEY = System.getProperty("oauth.remembercookie.secretkey");

    public static String serialize(LoginSessionToken loginSession, String callerPrincipal, List<String> roles) {
        JWTClaimsSet claimSet = new JWTClaimsSet.Builder().claim("principal", (Object)callerPrincipal).claim("roles", roles).claim("loginSession", (Object)loginSession.getValue()).build();
        String encryptedToken = EncryptedTokenSerializer.serialize(claimSet, RememberMeTokenUtil.getSecretKey());
        return encryptedToken;
    }

    private static byte[] getSecretKey() {
        return new Base64(SECRET_KEY).decode();
    }

    public static LoginSessionToken getLoginSession(String token) {
        JWTClaimsSet claimSet = EncryptedTokenSerializer.deserialize(token, RememberMeTokenUtil.getSecretKey());
        try {
            return new LoginSessionToken(claimSet.getStringClaim("loginSession"));
        }
        catch (ParseException e) {
            throw new OAuthException("expected valid loginSession in cookie", null);
        }
    }

    public static Collection<Principal> deserialize(String token) {
        JWTClaimsSet claimSet = EncryptedTokenSerializer.deserialize(token, RememberMeTokenUtil.getSecretKey());
        try {
            ArrayList<Principal> preparedPrincipals = new ArrayList<Principal>();
            SimplePrincipal principal = new SimplePrincipal(claimSet.getStringClaim("principal"));
            preparedPrincipals.add((Principal)principal);
            SimpleGroup callerGroup = new SimpleGroup("CallerPrincipal");
            preparedPrincipals.add((Principal)callerGroup);
            callerGroup.addMember((Principal)principal);
            SimpleGroup rolesGroup = new SimpleGroup("Roles");
            preparedPrincipals.add((Principal)rolesGroup);
            for (String object : claimSet.getStringArrayClaim("roles")) {
                if (!(object instanceof String)) continue;
                rolesGroup.addMember((Principal)new SimplePrincipal(object));
            }
            return preparedPrincipals;
        }
        catch (ParseException e) {
            throw new OAuthException("expected valid roles and principal in cookie", null);
        }
    }

    public static boolean isEnabled() {
        return SECRET_KEY != null;
    }
}

